<?php

add_action('init', 'featured_box_integrateWithVC');

function featured_box_integrateWithVC() {
    vc_map(array(
        "name" => esc_html__("Featured Box", 'organicfood'),
        "base" => "featured-box",
        "class" => "featured-box",
        "category" => esc_html__('Organic Food', 'organicfood'),
        "icon" => "of-icon-for-vc",
        "params" => array(
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Box Type", 'organicfood'),
                "param_name" => "box_type",
                "value" => array(
                    "Text" => "text",
                    "Icon" => "icon",
                    "Image" => "image",
                ),
				"std" => "text",
                "description" => esc_html__('Box Type', 'organicfood')
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Box Position", 'organicfood'),
                "param_name" => "box_position",
                "value" => array(
                    esc_html__("Box Left", 'organicfood') => "box-left",
                    esc_html__("Box Right", 'organicfood') => "box-right",
                    esc_html__("Box Center", 'organicfood') => "box-center",
                ),
				"std" => "box-left",
                "description" => esc_html__('Box Position', 'organicfood')
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Box Inner Type", 'organicfood'),
                "param_name" => "box_inner_type",
                "value" => array(
                    "None" => "box-none",
                    "Square" => "box-square",
                    "Circle" => "box-circle",
                    
                ),
				"std" => "box-none",
                "dependency" => array(
                    "element"=>"box_type",
                    "value"=> array("text", "icon")
                ),
                "description" => esc_html__('Box Inner Type', 'organicfood')
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Box Style", 'organicfood'),
                "param_name" => "box_style",
                "value" => array(
                    "None" => "",
                    "Background" => "box-background",
                    "Border" => "box-border",
                    
                ),
				"std" => "",
                "dependency" => array(
                    "element"=>"box_inner_type",
                    "value"=> array("box-square", "box-circle")
                ),
                "description" => esc_html__('Box Style.', 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Box Text", 'organicfood'),
                "param_name" => "box_text",
                "value" => "",
                "dependency" => array(
                    "element"=>"box_type",
                    "value"=>"text"
                ),
                "description" => esc_html__("Box Text.", 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Box Icon", 'organicfood'),
                "param_name" => "box_icon",
                "value" => "",
                "dependency" => array(
                    "element"=>"box_type",
                    "value"=>"icon"
                ),
                "description" => esc_html__("Box Icon.", 'organicfood')
            ),
            array(
                "type" => "attach_image",
                "holder" => "",
                "class" => "",
                "heading" => esc_html__("Box Image", 'organicfood'),
                "param_name" => "box_image",
                "value" => "",
                "dependency" => array(
                    "element"=>"box_type",
                    "value"=>"image"
                ),
                "description" => esc_html__("Box Image.", 'organicfood')
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__("Box Title", 'organicfood'),
                "param_name" => "box_title",
                "value" => "",
                "description" => esc_html__("Box Title.", 'organicfood')
            ), 
            array(
                "type" => "textarea_html",
                "class" => "",
                "heading" => esc_html__("Box Content", 'organicfood'),
                "param_name" => "content",
                "value" => "",
                "description" => esc_html__("Box Content.", 'organicfood')
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Animation", 'organicfood'),
                "param_name" => "animation",
                "value" => array(
                    "No" => "",
                    "Top to bottom" => "top-to-bottom",
                    "Bottom to top" => "bottom-to-top",
                    "Left to right" => "left-to-right",
                    "Right to left" => "right-to-left",
                    "Appear from center" => "appear"
                ),
				"std" => "",
                "description" => esc_html__("Animation", 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Extra Class", 'organicfood'),
                "param_name" => "el_class",
                "value" => "",
                "description" => esc_html__("Extra Class.", 'organicfood')
            ),
        )
    ));
}
