<?php

add_action('init', 'grid_integrateWithVC');

function grid_integrateWithVC() {
    vc_map(array(
        "name" => esc_html__("Grid", 'organicfood'),
        "base" => "grid",
        "class" => "grid",
        "category" => esc_html__('Organic Food', 'organicfood'),
        "icon" => "of-icon-for-vc",
        "params" => array(
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__("Post Type", 'organicfood'),
                "param_name" => "post_type",
                "value" => array(
                    "Post" => "post",
                    "Portfolio" => "portfolio",
                ),
				"std" => "post",
            ),
            array(
                "type" => "checkbox",
                "heading" => esc_html__('Show Filter', 'organicfood'),
                "param_name" => "show_filter",
                "value" => array(
                    esc_html__("Yes, please", 'organicfood') => 1
                ),
                "description" => esc_html__('Show or hide filter on your grid.', 'organicfood')
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Columns Extra Screen", 'organicfood'),
                "param_name" => "col_xs",
				"std" => "col-sx-12",
                "value" => array(
                    "1 Column" => "col-sx-12",
                    "2 Columns" => "col-sx-6",
                    "3 Columns" => "col-sx-4",
                    "4 Columns" => "col-sx-3",
                    "6 Columns" => "col-sx-2",
                ),
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Columns Small Screen", 'organicfood'),
                "param_name" => "col_sm",
				"std" => "col-sx-12",
                "value" => array(
                    "1 Column" => "col-sm-12",
                    "2 Columns" => "col-sm-6",
                    "3 Columns" => "col-sm-4",
                    "4 Columns" => "col-sm-3",
                    "6 Columns" => "col-sm-2",
                ),
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Columns Medium Screen", 'organicfood'),
                "param_name" => "col_md",
				"std" => "col-sx-12",
                "value" => array(
                    "1 Column" => "col-md-12",
                    "2 Columns" => "col-md-6",
                    "3 Columns" => "col-md-4",
                    "4 Columns" => "col-md-3",
                    "6 Columns" => "col-md-2",
                ),
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Columns Large Screen", 'organicfood'),
                "param_name" => "col_lg",
				"std" => "col-sx-12",
                "value" => array(
                    "1 Column" => "col-lg-12",
                    "2 Columns" => "col-lg-6",
                    "3 Columns" => "col-lg-4",
                    "4 Columns" => "col-lg-3",
                    "6 Columns" => "col-lg-2",
                ),
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Style", 'organicfood'),
                "param_name" => "style",
				"std" => "style1",
                "value" => array(
                    "Style 1" => "style1",
                ),
                "description" => esc_html__('Style', 'organicfood')
            ),
            
            array(
                "type" => "checkbox",
                "heading" => esc_html__('Show Title', 'organicfood'),
                "param_name" => "show_title",
                "value" => array(
                    esc_html__("Yes, please", 'organicfood') => true
                ),
                "description" => esc_html__('Show or hide title of post on your grid.', 'organicfood')
            ),
            array(
                "type" => "checkbox",
                "heading" => esc_html__('Show Description', 'organicfood'),
                "param_name" => "show_description",
                "value" => array(
                    esc_html__("Yes, please", 'organicfood') => true
                ),
                "description" => esc_html__('Show or hide description of post on your grid.', 'organicfood')
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__('Excerpt Length', 'organicfood'),
                "param_name" => "excerpt_length",
                "value" => '',
                "description" => esc_html__('The length of the excerpt, number of words to display.', 'organicfood')
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__('Excerpt More', 'organicfood'),
                "param_name" => "excerpt_more",
                "value" => "",
                "description" => esc_html__('Excerpt More', 'organicfood')
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__('Order by', 'organicfood'),
                "param_name" => "orderby",
				"std" => "none",
                "value" => array(
                    "None" => "none",
                    "Title" => "title",
                    "Date" => "date",
                    "ID" => "ID"
                ),
                "description" => esc_html__('Order by ("none", "title", "date", "ID").', 'organicfood')
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__('Order', 'organicfood'),
                "param_name" => "order",
				"std" => "none",
                "value" => Array(
                    "None" => "none",
                    "ASC" => "ASC",
                    "DESC" => "DESC"
                ),
                "description" => esc_html__('Order ("None", "Asc", "Desc").', 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Extra Class", 'organicfood'),
                "param_name" => "el_class",
                "value" => "",
                "description" => esc_html__("Extra Class.", 'organicfood')
            ),
        )
    ));
}
