<?php

add_action('init', 'title_integrateWithVC');

function title_integrateWithVC() {
    vc_map(array(
        "name" => esc_html__("Title", 'organicfood'),
        "base" => "title",
        "class" => "title",
        "category" => esc_html__('Organic Food', 'organicfood'),
        "icon" => "of-icon-for-vc",
        "params" => array(
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__("Title", 'organicfood'),
                "param_name" => "title",
                "value" => "",
                "description" => esc_html__("Content.", 'organicfood')
            ),
            array (
                "type" => "colorpicker",
                "heading" => __ ( 'Color', 'organicfood' ),
                "param_name" => "color",
                "value" => '',
                "description" => __ ( 'Color', 'organicfood' ),
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Align", 'organicfood'),
                "param_name" => "align",
                "value" => array(
                    "None" => "",
                    "Left" => "text-left",
                    "Right" => "text-right",
                    "Center" => "text-center"
                ),
				"std" => "",
                "description" => esc_html__("Align", 'organicfood')
            ),
            array(
                "type" => "checkbox",
                "class" => "",
                "heading" => esc_html__("Underline", 'organicfood'),
                "param_name" => "underline",
                "value" => array (
                                __ ( "Yes, please", 'organicfood' ) => 1
                ),
                "description" => esc_html__("Underline.", 'organicfood')
            ),            
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Animation", 'organicfood'),
                "param_name" => "animation",
                "value" => array(
                    "No" => "",
                    "Top to bottom" => "top-to-bottom",
                    "Bottom to top" => "bottom-to-top",
                    "Left to right" => "left-to-right",
                    "Right to left" => "right-to-left",
                    "Appear from center" => "appear"
                ),
				"std" => "",
                "description" => esc_html__("Animation", 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Extra Class", 'organicfood'),
                "param_name" => "el_class",
                "value" => "",
                "description" => esc_html__("Extra Class.", 'organicfood')
            ),
        )
    ));
}
