<?php

#-----------------------------------------------------------------#
# Create admin testimonial section
#-----------------------------------------------------------------#

function ww_add_post_type_testimonial() {
    $testimonial_labels = array(
        'name'          => esc_html__('Testimonials', 'organicfood'),
        'singular_name' => esc_html__('Testimonial Item', 'organicfood'),
        'search_items'  => esc_html__('Search Testimonial Items', 'organicfood'),
        'all_items'     => esc_html__('Testimonial', 'organicfood'),
        'parent_item'   => esc_html__('Parent Testimonial Item', 'organicfood'),
        'edit_item'     => esc_html__('Edit Testimonial Item', 'organicfood'),
        'update_item'   => esc_html__('Update Testimonial Item', 'organicfood'),
        'add_new_item'  => esc_html__('Add New Testimonial Item', 'organicfood'),
        'not_found'     => esc_html__('No testimonial found', 'organicfood')
    );

    $options = get_option('cshero');
    $custom_slug = null;

    if (!empty($options['testimonial_rewrite_slug']))
        $custom_slug = $options['testimonial_rewrite_slug'];

    $args = array(
        'labels'             => $testimonial_labels,
        'rewrite'            => array('slug' => $custom_slug, 'with_front' => false),
        'singular_label'     => esc_html__('Project', 'organicfood'),
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'hierarchical'       => false,
        'menu_position'      => 5,
        'menu_icon'          => 'dashicons-yes',
        'supports'           => array('title', 'editor', 'thumbnail', 'comments')
    );

    if(function_exists('custom_reg_post_type')) {
        custom_reg_post_type('testimonial', $args);
    }

    if(function_exists('custom_reg_taxonomy')) {
        custom_reg_taxonomy('testimonial_category', 'testimonial', array('hierarchical' => true, 'label' => esc_html__('Testimonial Categories', 'organicfood'), 'query_var' => true, 'rewrite' => true));
    }
    $labels = array(
        'name'                       => esc_html__('Testimonial Tags', 'organicfood'),
        'singular_name'              => esc_html__('Tag', 'organicfood'),
        'search_items'               => esc_html__('Search Tags', 'organicfood'),
        'popular_items'              => esc_html__('Popular Tags', 'organicfood'),
        'all_items'                  => esc_html__('All Tags', 'organicfood'),
        'parent_item'                => null,
        'parent_item_colon'          => null,
        'edit_item'                  => esc_html__('Edit Tag', 'organicfood'),
        'update_item'                => esc_html__('Update Tag', 'organicfood'),
        'add_new_item'               => esc_html__('Add New Tag', 'organicfood'),
        'new_item_name'              => esc_html__('New Tag Name', 'organicfood'),
        'separate_items_with_commas' => esc_html__('Separate tags with commas', 'organicfood'),
        'add_or_remove_items'        => esc_html__('Add or remove tags', 'organicfood'),
        'choose_from_most_used'      => esc_html__('Choose from the most used tags', 'organicfood'),
        'menu_name'                  => esc_html__('Testimonial Tags', 'organicfood'),
    );

    if(function_exists('custom_reg_taxonomy')) {
        custom_reg_taxonomy('testimonial_tag', 'testimonial', array(
            'hierarchical' => false,
            'labels' => $labels,
            'show_ui' => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var' => true,
            'rewrite' => array('slug' => 'tag'),
        ));
    }
}

add_action('init', 'ww_add_post_type_testimonial');