<?php

class Organicfood_Generator {
	 
    protected $scssc = null;
  
	function __construct() {
		add_action( 'init', array( $this, 'init' ) );
	}

 
	function init() {
		if ( ! class_exists( 'scssc' ) ) {
			return;
		}
		add_action( 'wp', array( $this, 'generate_with_dev_mode' ) );
	}

	function generate_with_dev_mode() {
		global $smof_data;
		if(isset($smof_data['dev_mode'])&&$smof_data['dev_mode']==1){
			$this->generate_file();
		}
	}

	/**
	 * Generate options and css files
	 */
	function generate_file() {
		global $wp_filesystem;  
		if(is_null($wp_filesystem)){
			require_once ( ABSPATH . '/wp-admin/includes/file.php' );
	    	WP_Filesystem();
	    }
		
		if (empty($wp_filesystem)) return;

		$scss_dir = get_template_directory() . '/framework/assets/scss/';
		$css_dir  = get_template_directory() . '/css/';

		$this->scssc = new scssc();
		$this->scssc->setImportPaths( $scss_dir );
 
		$css_file = $css_dir . 'theme.css';
 
		$this->scssc->setFormatter( 'scss_formatter' );
 
		$_options = $scss_dir . 'options.scss';

 		$wp_filesystem->delete($_options);
 		$wp_filesystem->delete($css_file);

		$wp_filesystem->put_contents($_options, $this->options_output(), FS_CHMOD_FILE);
        $wp_filesystem->put_contents($css_file, $this->scssc->compile('@import "theme.scss"'), FS_CHMOD_FILE);
		 
	}

	function options_output() {
		$smof_data = of_get_options();
		$primary_color         = isset($smof_data['primary_color']) && !empty($smof_data['primary_color']) ? $smof_data['primary_color'] : '#69bd43';
		$heading_color         = isset($smof_data['heading_color']) && !empty($smof_data['heading_color']) ? $smof_data['heading_color'] : '#666666';
		$link_color            = isset($smof_data['link_color']) && !empty($smof_data['link_color']) ? $smof_data['link_color'] : '#69bd43';
		$link_color_hover      = isset($smof_data['link_color_hover']) && !empty($smof_data['link_color_hover']) ? $smof_data['link_color_hover'] : '#3f7228';
		$body_text_color       = isset($smof_data['body_text_color']) && !empty($smof_data['body_text_color']) ? $smof_data['body_text_color'] : '#666666';
		$button_text_color     = isset($smof_data['button_text_color']) && !empty($smof_data['button_text_color']) ? $smof_data['button_text_color'] : '#ffffff';
		/*$button_bg_color       = isset($smof_data['button_bg_color']) && !empty($smof_data['button_bg_color']) ? $smof_data['button_bg_color'] : $primary_color;*/
		$button_bg_color       = $primary_color;

		$button_bg_color_hover = isset($smof_data['button_bg_color_hover']) && !empty($smof_data['button_bg_color_hover']) ? $smof_data['button_bg_color_hover'] : $link_color_hover;
		
		ob_start();
		printf( '$primary_color:%s;',$primary_color);
		printf( '$heading_color:%s;',$heading_color);
		printf( '$link_color:%s;',$link_color);
		printf( '$link_color_hover:%s;',$link_color_hover);
		printf( '$body_text_color:%s;',$body_text_color);
		printf( '$button_text_color:%s;',$button_text_color);
		printf( '$button_bg_color:%s;',$button_bg_color);
		printf( '$button_bg_color_hover:%s;',$button_bg_color_hover);

		return ob_get_clean();
	}
	  
}

new Organicfood_Generator();