<?php

add_action('init', 'block_integrateWithVC');

function block_integrateWithVC() {
    vc_map(array(
        "name" => esc_html__("Block", 'organicfood'),
        "base" => "block",
        "class" => "block",
        "category" => esc_html__('Organic Food', 'organicfood'),
        "icon" => "of-icon-for-vc",
        "params" => array(
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Style", 'organicfood'),
                "param_name" => "style",
				"std" => "style1",
                "value" => array(
                    "Style 1" => "style1",
                    "Style 2" => "style2",
                ),
                "description" => esc_html__('Style', 'organicfood')
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__("Title", 'organicfood'),
                "param_name" => "title",
                "value" => "",
                "description" => esc_html__("Title.", 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Link", 'organicfood'),
                "param_name" => "link",
                "value" => "",
                "description" => esc_html__("Link.", 'organicfood')
            ),
            array(
                "type" => "attach_image",
                "class" => "",
                "heading" => esc_html__("Image", 'organicfood'),
                "param_name" => "image",
                "value" => "",
                "description" => esc_html__("Image.", 'organicfood')
            ),
            array(
                "type" => "checkbox",
                "heading" => esc_html__('Show Mosaic Hover', 'organicfood'),
                "param_name" => "mosaic_hover",
                "value" => array(
                    esc_html__("Yes, please", 'organicfood') => true
                ),
                "description" => esc_html__('Show or hide mosaic hover.', 'organicfood')
            ),
            array(
                "type" => "textarea_html",
                "class" => "",
                "heading" => esc_html__("Content", 'organicfood'),
                "param_name" => "content",
                "value" => "",
                "description" => esc_html__("Content.", 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Extra Class", 'organicfood'),
                "param_name" => "el_class",
                "value" => "",
                "description" => esc_html__("Extra Class.", 'organicfood')
            ),
        )
    ));
}
