<?php
// Register Custom Post Type
function cs_add_post_type_portfolio() {
    // Register taxonomy
    $labels = array(
            'name'              => esc_html__( 'Portfolio Category', 'organicfood' ),
            'singular_name'     => esc_html__( 'Portfolio Category', 'organicfood' ),
            'search_items'      => esc_html__( 'Search Portfolio Category', 'organicfood' ),
            'all_items'         => esc_html__( 'All Portfolio Category', 'organicfood' ),
            'parent_item'       => esc_html__( 'Parent Portfolio Category', 'organicfood' ),
            'parent_item_colon' => esc_html__( 'Parent Portfolio Category:', 'organicfood' ),
            'edit_item'         => esc_html__( 'Edit Portfolio Category', 'organicfood' ),
            'update_item'       => esc_html__( 'Update Portfolio Category', 'organicfood' ),
            'add_new_item'      => esc_html__( 'Add New Portfolio Category', 'organicfood' ),
            'new_item_name'     => esc_html__( 'New Portfolio Category Name', 'organicfood' ),
            'menu_name'         => esc_html__( 'Portfolio Category', 'organicfood' ),
    );

    $args = array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array( 'slug' => 'portfolio_category' ),
    );
    if(function_exists('custom_reg_taxonomy')) {
        custom_reg_taxonomy( 'portfolio_category', array( 'portfolio' ), $args );
    }
    //Register tags
    $labels = array(
            'name'              => esc_html__( 'Portfolio Tag', 'organicfood' ),
            'singular_name'     => esc_html__( 'Portfolio Tag', 'organicfood' ),
            'search_items'      => esc_html__( 'Search Portfolio Tag', 'organicfood' ),
            'all_items'         => esc_html__( 'All Portfolio Tag', 'organicfood' ),
            'parent_item'       => esc_html__( 'Parent Portfolio Tag', 'organicfood' ),
            'parent_item_colon' => esc_html__( 'Parent Portfolio Tag:', 'organicfood' ),
            'edit_item'         => esc_html__( 'Edit Portfolio Tag', 'organicfood' ),
            'update_item'       => esc_html__( 'Update Portfolio Tag', 'organicfood' ),
            'add_new_item'      => esc_html__( 'Add New Portfolio Tag', 'organicfood' ),
            'new_item_name'     => esc_html__( 'New Portfolio Tag Name', 'organicfood' ),
            'menu_name'         => esc_html__( 'Portfolio Tag', 'organicfood' ),
    );

    $args = array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array( 'slug' => 'portfolio_tag' ),
    );
    
    if(function_exists('custom_reg_taxonomy')) {
        custom_reg_taxonomy( 'portfolio_tag', array( 'portfolio' ), $args );
    }
    
    //Register post type portfolio
    $labels = array(
            'name'                => esc_html__( 'Portfolio', 'organicfood' ),
            'singular_name'       => esc_html__( 'Portfolio Item', 'organicfood' ),
            'menu_name'           => esc_html__( 'Portfolio', 'organicfood' ),
            'parent_item_colon'   => esc_html__( 'Parent Item:', 'organicfood' ),
            'all_items'           => esc_html__( 'All Items', 'organicfood' ),
            'view_item'           => esc_html__( 'View Item', 'organicfood' ),
            'add_new_item'        => esc_html__( 'Add New Item', 'organicfood' ),
            'add_new'             => esc_html__( 'Add New', 'organicfood' ),
            'edit_item'           => esc_html__( 'Edit Item', 'organicfood' ),
            'update_item'         => esc_html__( 'Update Item', 'organicfood' ),
            'search_items'        => esc_html__( 'Search Item', 'organicfood' ),
            'not_found'           => esc_html__( 'Not found', 'organicfood' ),
            'not_found_in_trash'  => esc_html__( 'Not found in Trash', 'organicfood' ),
    );
    $args = array(
            'label'               => esc_html__( 'portfolio', 'organicfood' ),
            'description'         => esc_html__( 'Portfolio Description', 'organicfood' ),
            'labels'              => $labels,
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats', ),
            'taxonomies'          => array( 'portfolio_category', 'portfolio_tag' ),
            'hierarchical'        => true,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'menu_icon'           => 'dashicons-welcome-view-site',
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'page',
    );
    
    if(function_exists('custom_reg_post_type')) {
        custom_reg_post_type( 'portfolio', $args );
    }
    
}

// Hook into the 'init' action
add_action( 'init', 'cs_add_post_type_portfolio', 0 );
