<?php
// Register Custom Post Type
function cs_add_post_type_recipe() {
    // Register taxonomy
    $labels = array(
            'name'              => esc_html__( 'Recipe Category', 'organicfood' ),
            'singular_name'     => esc_html__( 'Recipe Category', 'organicfood' ),
            'search_items'      => esc_html__( 'Search Recipe Category', 'organicfood' ),
            'all_items'         => esc_html__( 'All Recipe Category', 'organicfood' ),
            'parent_item'       => esc_html__( 'Parent Recipe Category', 'organicfood' ),
            'parent_item_colon' => esc_html__( 'Parent Recipe Category:', 'organicfood' ),
            'edit_item'         => esc_html__( 'Edit Recipe Category', 'organicfood' ),
            'update_item'       => esc_html__( 'Update Recipe Category', 'organicfood' ),
            'add_new_item'      => esc_html__( 'Add New Recipe Category', 'organicfood' ),
            'new_item_name'     => esc_html__( 'New Recipe Category Name', 'organicfood' ),
            'menu_name'         => esc_html__( 'Recipe Category', 'organicfood' ),
    );

    $args = array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array( 'slug' => 'recipe_category' ),
    );
    
    if(function_exists('custom_reg_taxonomy')) {
        custom_reg_taxonomy('recipe_category', array( 'recipe' ), $args );
    }
    
    //Register tags
    $labels = array(
            'name'              => esc_html__( 'Recipe Tag', 'organicfood' ),
            'singular_name'     => esc_html__( 'Recipe Tag', 'organicfood' ),
            'search_items'      => esc_html__( 'Search Recipe Tag', 'organicfood' ),
            'all_items'         => esc_html__( 'All Recipe Tag', 'organicfood' ),
            'parent_item'       => esc_html__( 'Parent Recipe Tag', 'organicfood' ),
            'parent_item_colon' => esc_html__( 'Parent Recipe Tag:', 'organicfood' ),
            'edit_item'         => esc_html__( 'Edit Recipe Tag', 'organicfood' ),
            'update_item'       => esc_html__( 'Update Recipe Tag', 'organicfood' ),
            'add_new_item'      => esc_html__( 'Add New Recipe Tag', 'organicfood' ),
            'new_item_name'     => esc_html__( 'New Recipe Tag Name', 'organicfood' ),
            'menu_name'         => esc_html__( 'Recipe Tag', 'organicfood' ),
    );

    $args = array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array( 'slug' => 'recipe_tag' ),
    );
    
    if(function_exists('custom_reg_taxonomy')) {
        custom_reg_taxonomy( 'recipe_tag', array( 'recipe' ), $args );
    }
    
    //Register post type portfolio
    $labels = array(
            'name'                => _x( 'Recipe', 'Post Type General Name', 'organicfood' ),
            'singular_name'       => _x( 'Recipe Item', 'Post Type Singular Name', 'organicfood' ),
            'menu_name'           => esc_html__( 'Recipe', 'organicfood' ),
            'parent_item_colon'   => esc_html__( 'Parent Item:', 'organicfood' ),
            'all_items'           => esc_html__( 'All Items', 'organicfood' ),
            'view_item'           => esc_html__( 'View Item', 'organicfood' ),
            'add_new_item'        => esc_html__( 'Add New Item', 'organicfood' ),
            'add_new'             => esc_html__( 'Add New', 'organicfood' ),
            'edit_item'           => esc_html__( 'Edit Item', 'organicfood' ),
            'update_item'         => esc_html__( 'Update Item', 'organicfood' ),
            'search_items'        => esc_html__( 'Search Item', 'organicfood' ),
            'not_found'           => esc_html__( 'Not found', 'organicfood' ),
            'not_found_in_trash'  => esc_html__( 'Not found in Trash', 'organicfood' ),
    );
    $args = array(
            'label'               => esc_html__( 'Recipe', 'organicfood' ),
            'description'         => esc_html__( 'Recipe Description', 'organicfood' ),
            'labels'              => $labels,
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments' ),
            'taxonomies'          => array( 'recipe_category', 'recipe_tag' ),
            'hierarchical'        => true,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'menu_icon'           => 'dashicons-pressthis',
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'page',
    );
    
    if(function_exists('custom_reg_post_type')) {
        custom_reg_post_type( 'recipe', $args );
    }

}

// Hook into the 'init' action
add_action( 'init', 'cs_add_post_type_recipe', 0 );
