<?php
#-----------------------------------------------------------------#
# Create admin team section
#-----------------------------------------------------------------#
function ww_add_post_type_team() {
    $team_labels = array(
        'name'          => esc_html__('Team', 'organicfood'),
        'singular_name' => esc_html__('Team Item', 'organicfood'),
        'search_items'  => esc_html__('Search Team Items', 'organicfood'),
        'all_items'     => esc_html__('Team', 'organicfood'),
        'parent_item'   => esc_html__('Parent Team Item', 'organicfood'),
        'edit_item'     => esc_html__('Edit Team Item', 'organicfood'),
        'update_item'   => esc_html__('Update Team Item', 'organicfood'),
        'add_new_item'  => esc_html__('Add New Team Item', 'organicfood'),
        'not_found'     => esc_html__('No team found', 'organicfood')
    );
    $options = get_option('cshero');
    $custom_slug = null;
    if (!empty($options['team_rewrite_slug']))
        $custom_slug = $options['team_rewrite_slug'];
    $args = array(
        'labels' => $team_labels,
        'rewrite' => array('slug' => $custom_slug, 'with_front' => false),
        'singular_label' => esc_html__('Project', 'organicfood'),
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'hierarchical' => false,
        'menu_position' => 9,
        'menu_icon' => 'dashicons-groups',
        'supports' => array('title', 'editor', 'thumbnail', 'comments')
    );
    
    if(function_exists('custom_reg_post_type')) {
        custom_reg_post_type('team', $args);
    }
    
    if(function_exists('custom_reg_taxonomy')) {
        custom_reg_taxonomy("team_category", array("team"), array("hierarchical" => true, "label" => esc_html__('Team Categories', 'organicfood'), 'query_var' => true, 'rewrite' => true));
    }
    
}
add_action('init', 'ww_add_post_type_team');