<?php 
global $wp;
if(!empty($wp->request))
    $url = home_url(add_query_arg(array(),$wp->request));
else
    if(function_exists('cms_current_url')) 
        $url = cms_current_url();
?>
<div class="wrap" id="of_container">

    <div id="of-popup-save" class="of-save-popup">
        <div class="of-save-save"><?php echo esc_html__('Options Updated','organicfood'); ?></div>
    </div>

    <div id="of-popup-reset" class="of-save-popup">
        <div class="of-save-reset"><?php echo esc_html__('Options Reset','organicfood'); ?></div>
    </div>

    <div id="of-popup-fail" class="of-save-popup">
        <div class="of-save-fail"><?php echo esc_html__('Error!','organicfood'); ?></div>
    </div>

    <span style="display: none;" id="hooks"><?php echo json_encode(of_get_header_classes_array()); ?></span>
    <input type="hidden" id="reset" value="<?php if (isset($_REQUEST['reset'])) echo esc_attr($_REQUEST['reset']); ?>" />
    <input type="hidden" id="security" name="security" value="<?php echo wp_create_nonce('of_ajax_nonce'); ?>" />

    <form id="of_form" method="post" action="<?php echo esc_attr($url) ?>" enctype="multipart/form-data" >

        <div id="header">

            <div class="logo">
                <div class="heading"><?php echo esc_html__('Organic Food','organicfood'); ?></div>
                <span><?php echo ('v' . THEMEVERSION); ?></span>
            </div>

            <div id="js-warning"><?php echo esc_html__('Warning- This options panel will not work properly without javascript!','organicfood');?></div>
            <div class="icon-option"></div>
            <div class="clear"></div>

        </div>

        <div id="info_bar">

            <a>
                <div id="expand_options" class="expand"><?php echo esc_html__('Expand','organicfood'); ?></div>
            </a>

            <img style="display:none" src="<?php echo ADMIN_DIR; ?>assets/images/loading-bottom.gif" class="ajax-loading-img ajax-loading-img-bottom" alt="Working..." />

            <button type="button" class="of_save button-primary">
                <?php esc_html_e('Save All Changes', 'organicfood'); ?>
            </button>

        </div><!--.info_bar-->

        <div id="main">

            <div id="of-nav">
                <ul>
                    <?php echo ''.$options_machine->Menu ?>
                </ul>
            </div>

            <div id="content">
                <?php echo ''.$options_machine->Inputs ?>
            </div>

            <div class="clear"></div>

        </div>

        <div class="save_bar">

            <img style="display:none" src="<?php echo ADMIN_DIR; ?>assets/images/loading-bottom.gif" class="ajax-loading-img ajax-loading-img-bottom" alt="<?php esc_attr_e('Working...','organicfood')?>" />
            <button type="button" class="of_save button-primary"><?php esc_html_e('Save All Changes', 'organicfood'); ?></button>
            <button id ="of_reset" type="button" class="button submit-button reset-button" ><?php esc_html_e('Options Reset', 'organicfood'); ?></button>
            <img style="display:none" src="<?php echo ADMIN_DIR; ?>assets/images/loading-bottom.gif" class="ajax-reset-loading-img ajax-loading-img-bottom" alt="Working..." />

        </div><!--.save_bar-->

    </form>

    <div style="clear:both;"></div>

</div><!--wrap-->
<div class="smof_footer_info"><?php esc_html_e('Slightly Modified Options Framework', 'organicfood'); ?> <strong><?php echo SMOF_VERSION; ?></strong></div>