<?php
add_action('init', 'of_options');

if (!function_exists('of_options')) {
    function of_options()
    {
        //Access the WordPress Categories via an Array
        $of_categories = array();
        $of_categories_obj = get_categories('hide_empty=0');
        foreach ($of_categories_obj as $of_cat) {
            $of_categories[$of_cat->cat_ID] = $of_cat->cat_name;
        }
        $categories_tmp = array_unshift($of_categories, "Select a category:");

        //Access the WordPress Pages via an Array
        $of_pages = array();
        $of_pages_obj = get_pages('sort_column=post_parent,menu_order');
        foreach ($of_pages_obj as $of_page) {
            $of_pages[$of_page->ID] = $of_page->post_name;
        }
        $of_pages_tmp = array_unshift($of_pages, "Select a page:");

        //Testing
        $of_options_select = array("one", "two", "three", "four", "five");
        $of_options_radio = array("one" => "One", "two" => "Two", "three" => "Three", "four" => "Four", "five" => "Five");
        $of_options_fontsize = array("8px" => "8px", "9px" => "9px", "10px" => "10px", "11px" => "11px", "12px" => "12px", "13px" => "13px", "14px" => "14px", "15px" => "15px", "16px" => "16px", "17px" => "17px", "18px" => "18px", "19px" => "19px", "20px" => "20px", "21px" => "21px", "22px" => "22px", "23px" => "23px", "24px" => "24px", "25px" => "25px", "26px" => "26px", "27px" => "27px", "28px" => "28px", "29px" => "29px", "30px" => "30px", "31px" => "31px", "32px" => "32px", "33px" => "33px", "34px" => "34px", "35px" => "35px", "36px" => "36px", "37px" => "37px", "38px" => "38px", "39px" => "39px", "40px" => "40px");
        $of_options_font = array("" => "None", "1" => "Google Font", "2" => "Standard Font", "3" => "Custom Font");
        //Sample Homepage blocks for the layout manager (sorter)
        $of_options_homepage_blocks = array
        (
            "disabled" => array(
                "placebo" => "placebo", //REQUIRED!
                "block_one" => "Block One",
                "block_two" => "Block Two",
                "block_three" => "Block Three",
            ),
            "enabled" => array(
                "placebo" => "placebo", //REQUIRED!
                "block_four" => "Block Four",
            ),
        );


        //Stylesheets Reader
        $alt_stylesheet_path = LAYOUT_PATH;
        $alt_stylesheets = array();

        if (is_dir($alt_stylesheet_path)) {
            if ($alt_stylesheet_dir = opendir($alt_stylesheet_path)) {
                while (($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false) {
                    if (stristr($alt_stylesheet_file, ".css") !== false) {
                        $alt_stylesheets[] = $alt_stylesheet_file;
                    }
                }
            }
        }


        //Background Images Reader
        $bg_images_path = get_stylesheet_directory() . '/images/bg/'; // change this to where you store your bg images
        $bg_images_url = URI_PATH . '/images/bg/'; // change this to where you store your bg images
        $bg_images = array();

        if ( is_dir($bg_images_path) ) {
            if ($bg_images_dir = opendir($bg_images_path) ) {
                while ( ($bg_images_file = readdir($bg_images_dir)) !== false ) {
                    if(stristr($bg_images_file, ".png") !== false || stristr($bg_images_file, ".jpg") !== false) {
                        natsort($bg_images); //Sorts the array into a natural order
                        $bg_images[] = $bg_images_url . $bg_images_file;
                    }
                }
            }
        }


        /*-----------------------------------------------------------------------------------*/
        /* TO DO: Add options/functions that use these */
        /*-----------------------------------------------------------------------------------*/

        //More Options
        $uploads_arr = wp_upload_dir();
        $all_uploads_path = $uploads_arr['path'];
        $all_uploads = get_option('of_uploads');
        $other_entries = array("Select a number:", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19");
        $body_size = array("auto auto", "contain", "cover");     
        $body_repeat = array("no-repeat", "repeat-x", "repeat-y", "repeat");
        $body_pos = array("top left", "top center", "top right", "center left", "center center", "center right", "bottom left", "bottom center", "bottom right");

        // Image Alignment radio box
        $of_options_thumb_align = array("alignleft" => "Left", "alignright" => "Right", "aligncenter" => "Center");

        // Image Links to Options
        $of_options_image_link_to = array("image" => "The Image", "post" => "The Post");

        //Google font API
        $of_options_google_font = array();
        $google_fonts = new GoogleFontRender;
        foreach ($google_fonts->json() as $font){
            $of_options_google_font[$font->family] = $font->family;
        }

        //Standard Fonts
        $of_options_standard_fonts = array(
            '0' => 'Select Font',
            'Arial, Helvetica, sans-serif' => 'Arial, Helvetica, sans-serif',
            "'Arial Black', Gadget, sans-serif" => "'Arial Black', Gadget, sans-serif",
            "'Bookman Old Style', serif" => "'Bookman Old Style', serif",
            "'Comic Sans MS', cursive" => "'Comic Sans MS', cursive",
            "Courier, monospace" => "Courier, monospace",
            "Garamond, serif" => "Garamond, serif",
            "Georgia, serif" => "Georgia, serif",
            "Impact, Charcoal, sans-serif" => "Impact, Charcoal, sans-serif",
            "'Lucida Console', Monaco, monospace" => "'Lucida Console', Monaco, monospace",
            "'Lucida Sans Unicode', 'Lucida Grande', sans-serif" => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
            "'MS Sans Serif', Geneva, sans-serif" => "'MS Sans Serif', Geneva, sans-serif",
            "'MS Serif', 'New York', sans-serif" => "'MS Serif', 'New York', sans-serif",
            "'Palatino Linotype', 'Book Antiqua', Palatino, serif" => "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
            "Tahoma, Geneva, sans-serif" => "Tahoma, Geneva, sans-serif",
            "'Times New Roman', Times, serif" => "'Times New Roman', Times, serif",
            "'Trebuchet MS', Helvetica, sans-serif" => "'Trebuchet MS', Helvetica, sans-serif",
            "Verdana, Geneva, sans-serif" => "Verdana, Geneva, sans-serif"
        );
        // Custom Font
        $fonts = array();
        $of_options_custom_fonts = array();
        $of_options_custom_fonts[''] = 'Select Font';
        $font_path = get_template_directory() . "/fonts";
        if (!$handle = opendir($font_path)) {
            $fonts = array();
        } else {
            while (false !== ($file = readdir($handle))) {
                if (strpos($file, ".ttf") !== false ||
                    strpos($file, ".eot") !== false ||
                    strpos($file, ".svg") !== false ||
                    strpos($file, ".woff") !== false
                ) {
                    $fonts[] = $file;
                }
            }
        }
        closedir($handle);

        foreach ($fonts as $font) {
            $font_name = str_replace(array('.ttf', '.eot', '.svg', '.woff'), '', $font);
            $of_options_custom_fonts[$font_name] = $font_name;
        }
        /* remove dup item */
        $of_options_custom_fonts = array_unique($of_options_custom_fonts);

        /*-----------------------------------------------------------------------------------*/
        /* The Options Array */
        /*-----------------------------------------------------------------------------------*/
        global $of_options;
        $of_options = array();
 
        $of_options[] = array("name" => esc_html__("General Settings", 'organicfood'),
            "type" => "heading"
        );
        $of_options[] = array("name" => esc_html__("Less", 'organicfood'),
            "desc" => "",
            "id" => "use_less",
            "std" => "<h3>".esc_html__("Less Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array("name" => esc_html__("Use Less", 'organicfood'),
            "desc" => esc_html__("Use the less.", 'organicfood'),
            "id" => "use_less",
            "std" => 0,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        // begin Layout
        $of_options[] = array("name" => esc_html__("Smoothscroll", 'organicfood'),
            "desc" => "",
            "id" => "smoothscroll",
            "std" => "<h3>".esc_html__("Smoothscroll Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        
        $of_options[] = array("name" => esc_html__("Smoothscroll", 'organicfood'),
            "desc" => esc_html__("Smoothscroll", 'organicfood'),
            "id" => "smoothscroll",
            "std" => 0,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $of_options[] = array("name" => esc_html__("Layout", 'organicfood'),
            "desc" => "",
            "id" => "layout",
            "std" => "<h3>".esc_html__("Layout Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array("name" => esc_html__("Layout", 'organicfood'),
            "desc" => esc_html__("Select boxed or wide layout.", 'organicfood'),
            "id" => "layout",
            "std" => "full",
            "type" => "select",
            "options" => array(
                'full' => 'Wide',
                'boxed' => 'Boxed'
            ));
        // end Layout
        $of_options[] = array("name" => esc_html__("Boxed Mode Only", 'organicfood'),
            "desc" => "",
            "id" => "boxed_mode_only",
            "std" => "<h3>".esc_html__("Background options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array("name" => esc_html__("Background Image", 'organicfood'),
            "desc" => esc_html__("Select an image or insert an image url to use for the backgroud.", 'organicfood'),
            "id" => "bg_image",
            "std" => "",
            "mod" => "",
            "type" => "media");

        $of_options[] = array("name" => esc_html__("100% Background Image", 'organicfood'),
            "desc" => esc_html__("The background image display at 100% in width and height and scale according to the browser size.", 'organicfood'),
            "id" => "bg_full",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $of_options[] = array("name" => esc_html__("Background Repeat", 'organicfood'),
            "desc" => esc_html__("Select how the background image repeats.", 'organicfood'),
            "id" => "bg_repeat",
            "std" => "repeat",
            "type" => "select",
            "options" => array('repeat' => 'repeat', 'repeat-x' => 'repeat-x', 'repeat-y' => 'repeat-y', 'no-repeat' => 'no-repeat'));
        $of_options[] = array("name" => esc_html__("Background Position", 'organicfood'),
            "desc" => esc_html__("Select the position from where background image starts.", 'organicfood'),
            "id" => "bg_pos",
            "std" => "center center",
            "type" => "select",
            "options" => $body_pos);
        
        $of_options[] = array("name" => esc_html__("Background Pattern", 'organicfood'),
            "desc" => esc_html__("Display a pattern in the background. If Yes, select the pattern from below.", 'organicfood'),
            "id" => "bg_pattern_option",
            "std" => 0,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $of_options[] = array("name" => esc_html__("Select a Background Pattern", 'organicfood'),
            "desc" => esc_html__("Select a background pattern.", 'organicfood'),
            "id" => "bg_pattern",
            "std" => $bg_images_url . "bg0.png",
            "type" => "tiles",
            "fold" => "bg_pattern_option",
            "options" => $bg_images,
        );
       // begin Gutenberg
       
        $of_options[] = array("name" => esc_html__("Gutenberg Option", 'organicfood'),
            "desc" => "",
            "id" => "use_gutenberg",
            "std" => "<h3>".esc_html__("Gutenberg Option", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
      
        $of_options[] = array(
           "name" => esc_html__("Gutenberg", 'organicfood'),
           "desc" => esc_html__("Gutenberg Editor.", 'organicfood'),
           "id" => "gutenberg",
           "std" => 1,
           "on" => esc_html__("Disable", 'organicfood'),
           "off" => esc_html__("Default", 'organicfood'),
           "type" => "switch"
        );
        $of_options[] = array(
           "name" => esc_html__("Dev mode", 'organicfood'),
           "desc" => esc_html__("Dev mode", 'organicfood'),
           "id" => "dev_mode",
           "std" => 0,
           "on" => esc_html__("ON", 'organicfood'),
           "off" => esc_html__("OFF", 'organicfood'),
           "type" => "switch"
        );
        // end Gutenberg
/*Section Logo*/
        $of_options[] = array("name" => esc_html__("Logo", 'organicfood'),
            "type" => "heading");
         
        $of_options[] = array("name" => esc_html__("Logo Info", 'organicfood'),
            "desc" => "",
            "id" => "header_info",
            "std" => "<h3>".esc_html__("Logo Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");

        $of_options[] = array("name" => esc_html__("Logo", 'organicfood'),
            "desc" => esc_html__("Select an image file for your logo.", 'organicfood'),
            "id" => "logo",
            "std" => URI_PATH . "/images/logo.png",
            "mod" => "",
            "type" => "media");
        $of_options[] = array("name" => esc_html__("Logo Max Height", 'organicfood'),
            "desc" => esc_html__("Enter logo width, In pixels, ex: 40px", 'organicfood'),
            "id" => "logo_width",
            "std" => "45px",
            "type" => "text");
        $of_options[] = array("name" => esc_html__("Logo Margin", 'organicfood'),
            "desc" => esc_html__("In pixels, top right bottom left, ex: 10px 10px 10px 10px", 'organicfood'),
            "id" => "margin_logo",
            "std" => "0px",
            "type" => "text");

        $of_options[] = array("name" => esc_html__("Logo Padding", 'organicfood'),
            "desc" => esc_html__("In pixels, top right bottom left, ex: 10px 10px 10px 10px", 'organicfood'),
            "id" => "padding_logo",
            "std" => "0px",
            "type" => "text");
         
/*Section Header*/
        $of_options[] = array("name" => esc_html__("Header", 'organicfood'),
            "type" => "heading");

        $of_options[] = array("name" => esc_html__("Header Info", 'organicfood'),
            "desc" => "",
            "id" => "header_info",
            "std" => "<h3>".esc_html__("Header Content Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $headers = array(
                        "v1" => URI_PATH . "/images/header/header1.jpg",
                        "v2" => URI_PATH . "/images/header/header2.jpg",
                        "v3" => URI_PATH . "/images/header/header3.jpg"
                    );
        if (class_exists('Woocommerce')) {
            $headers['shop'] = URI_PATH . "/images/header/shop.jpg";
        }
        $of_options[] = array("name" => esc_html__("Select a Header Layout", 'organicfood'),
            "desc" => "",
            "id" => "header_layout",
            "std" => "v1",
            "type" => "images",
            "options" => $headers);
        $of_options[] = array("name" => esc_html__("Transparent Header", 'organicfood'),
            "desc" => esc_html__("Transparent Header.<br /> Min: 0, max: 100, step: 1, default value: 100", 'organicfood'),
            "id" => "header_transparent",
            "std" => "0",
            "min" => "0",
            "step" => "1",
            "max" => "100",
            "type" => "sliderui"
        );
        $of_options[] = array("name" => esc_html__("Header Top Widgets", 'organicfood'),
            "desc" => esc_html__("Display header top widgets.", 'organicfood'),
            "id" => "header_top_widgets",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $of_options[] = array("name" => esc_html__("Header Margin", 'organicfood'),
            "desc" => esc_html__("Header Margin, In pixels, top left botton right, ex: 10px 10px 10px 10px", 'organicfood'),
            "id" => "header_margin",
            "std" => "0px",
            "type" => "text");
        $of_options[] = array("name" => esc_html__("Header Padding", 'organicfood'),
            "desc" => esc_html__("Header Padding, In pixels, top left botton right, ex: 10px 10px 10px 10px", 'organicfood'),
            "id" => "header_padding",
            "std" => "0px",
            "type" => "text");
        $of_options[] = array("name" => esc_html__("Sticky Header Info", 'organicfood'),
            "desc" => "",
            "id" => "sticky_header_info",
            "std" => "<h3>".esc_html__("Sticky Header Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");

        $of_options[] = array("name" => esc_html__("Enable Sticky Header", 'organicfood'),
            "desc" => esc_html__("Enable a fixed header when scrolling.", 'organicfood'),
            "id" => "header_sticky",
            "std" => 0,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $of_options[] = array("name" => esc_html__("Sticky Header Opacity", 'organicfood'),
            "desc" => esc_html__("Set the opacity of background.<br /> Min: 0, max: 100, step: 1, default value: 45", 'organicfood'),
            "id" => "header_sticky_opacity",
            "id" => "header_sticky_opacity",
            "std" => "0",
            "min" => "0",
            "step" => "1",
            "max" => "100",
            "fold" => "header_sticky",  
            "type" => "sliderui"
        );
// end header

/*Section Main Menu*/
        $of_options[] = array("name" => esc_html__("Main Menu", 'organicfood'),
            "type" => "heading");

        $of_options[] = array("name" => esc_html__("Menu Info", 'organicfood'),
            "desc" => "",
            "id" => "header_info",
            "std" => "<h3>".esc_html__("Menu Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array("name" => esc_html__("Menu Item Padding", 'organicfood'),
            "desc" => esc_html__("Use a number without 'px', default is 5px 15px. ex: 5px 15px", 'organicfood'),
            "id" => "nav_padding",
            "std" => "5px 15px",
            "type" => "text");
        $of_options[] = array("name" => esc_html__("Menu Font Size First Level", 'organicfood'),
            "desc" => esc_html__("Use a number without 'px', default is 13px. ex: 13px", 'organicfood'),
            "id" => "menu_fontsize_first_level",
            "std" => "13px",
            "type" => "text");
        $of_options[] = array("name" => esc_html__("Menu Font Size First Sublevel", 'organicfood'),
            "desc" => esc_html__("Use a number without 'px', default is 12px. ex: 12px", 'organicfood'),
            "id" => "menu_fontsize_sub_level",
            "std" => "12px",
            "type" => "text");
/*Section Footer*/
        $of_options[] = array("name" => esc_html__("Footer", 'organicfood'),
            "type" => "heading");
        $of_options[] = array("name" => esc_html__("Footer Top Info", 'organicfood'),
            "desc" => "",
            "id" => "footer_top_info",
            "std" => "<h3>".esc_html__("Footer Top Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array("name" => esc_html__("Footer Top Widgets", 'organicfood'),
            "desc" => esc_html__("Display footer top widgets.", 'organicfood'),
            "id" => "footer_top_widgets",
            "std" => 0,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");

        $of_options[] = array("name" => esc_html__("Number of Footer Top Columns", 'organicfood'),
            "desc" => esc_html__("Select the number of columns to display in the footer top.", 'organicfood'),
            "id" => "footer_top_widgets_columns",
            "std" => "4",
            "options" => array('1' => '1', '2' => '2', '3' => '3', '4' => '4'),
            "type" => "select");
        $of_options[] = array("name" => esc_html__("Class Footer Widget 1", 'organicfood'),
            "desc" => esc_html__("Class follow the Bootstrap 3", 'organicfood'),
            "id" => "footer_top_widgets_1",
            "std" => "col-xs-12 col-sm-6 col-md-3 col-lg-3",
            "type" => "text");
        $of_options[] = array("name" => esc_html__("Class Footer Widget 2", 'organicfood'),
            "desc" => esc_html__("Class follow the Bootstrap 3", 'organicfood'),
            "id" => "footer_top_widgets_2",
            "std" => "col-xs-12 col-sm-6 col-md-3 col-lg-3",
            "type" => "text");
        $of_options[] = array("name" => esc_html__("Class Footer Widget 3", 'organicfood'),
            "desc" => esc_html__("Class follow the Bootstrap 3", 'organicfood'),
            "id" => "footer_top_widgets_3",
            "std" => "col-xs-12 col-sm-6 col-md-3 col-lg-3",
            "type" => "text");
        $of_options[] = array("name" => esc_html__("Class Footer Widget 4", 'organicfood'),
            "desc" => esc_html__("Class follow the Bootstrap 3", 'organicfood'),
            "id" => "footer_top_widgets_4",
            "std" => "col-xs-12 col-sm-6 col-md-3 col-lg-3",
            "type" => "text");

        $of_options[] = array("name" => esc_html__("Background Image", 'organicfood'),
            "desc" => esc_html__("Select an image or insert an image url to use for the footer top area backgroud.", 'organicfood'),
            "id" => "footer_top_bg_image",
            "std" => "",
            "mod" => "",
            "type" => "media");

        $of_options[] = array("name" => esc_html__("100% Background Image", 'organicfood'),
            "desc" => esc_html__("The footer top background image display at 100% in width and height and scale according to the browser size.", 'organicfood'),
            "id" => "footer_top_bg_full",
            "std" => 0,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");

        $of_options[] = array("name" => esc_html__("Background Repeat", 'organicfood'),
            "desc" => esc_html__("Select how the background image repeats.", 'organicfood'),
            "id" => "footer_top_bg_repeat",
            "std" => "repeat",
            "type" => "select",
            "options" => array('repeat' => 'repeat', 'repeat-x' => 'repeat-x', 'repeat-y' => 'repeat-y', 'no-repeat' => 'no-repeat'));

        $of_options[] = array("name" => esc_html__("Background Position", 'organicfood'),
            "desc" => esc_html__("Select the position from where background image starts.", 'organicfood'),
            "id" => "footer_top_bg_pos",
            "std" => "center center",
            "type" => "select",
            "options" => $body_pos);
        $of_options[] = array("name" => esc_html__("Footer Top Padding", 'organicfood'),
            "desc" => esc_html__("In pixels, top left botton right, ex: 35px 0px", 'organicfood'),
            "id" => "footer_top_padding",
            "std" => "35px 0px",
            "type" => "text");
         
        $of_options[] = array("name" => esc_html__("Footer Top Margin", 'organicfood'),
            "desc" => esc_html__("In pixels, top left botton right, ex: 10px 10px 10px 10px", 'organicfood'),
            "id" => "footer_top_margin",
            "std" => "0px",
            "type" => "text");

        // Footer Bottom
        $of_options[] = array("name" => esc_html__("Footer Bottom Info", 'organicfood'),
            "desc" => "",
            "id" => "footer_bottom_info",
            "std" => "<h3>".esc_html__("Footer Bottom Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array("name" => esc_html__("Footer Bottom Widgets", 'organicfood'),
            "desc" => esc_html__("Check the box to display footer bottom widgets.", 'organicfood'),
            "id" => "footer_bottom_widgets",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");

        $of_options[] = array("name" => esc_html__("Number of Footer Bottom Columns", 'organicfood'),
            "desc" => esc_html__("Select the number of columns to display in the footer bottom.", 'organicfood'),
            "id" => "footer_bottom_widgets_columns",
            "std" => "2",
            "options" => array('1' => '1', '2' => '2'),
            "type" => "select");
        $of_options[] = array("name" => esc_html__("Class Footer Bottom Widget 1", 'organicfood'),
            "desc" => esc_html__("Class follow the Bootstrap 3", 'organicfood'),
            "id" => "footer_bottom_widgets_1",
            "std" => "col-xs-12 col-sm-6 col-md-6 col-lg-6",
            "type" => "text");
        $of_options[] = array("name" => esc_html__("Class Footer Bottom Widget 2", 'organicfood'),
            "desc" => esc_html__("Class follow the Bootstrap 3", 'organicfood'),
            "id" => "footer_bottom_widgets_2",
            "std" => "col-xs-12 col-sm-6 col-md-6 col-lg-6",
            "type" => "text");

        $of_options[] = array("name" => esc_html__("Footer Bottom Padding", 'organicfood'),
            "desc" => esc_html__("In pixels, top left botton right, ex: 10px 10px 10px 10px", 'organicfood'),
            "id" => "footer_bottom_padding",
            "std" => "35px 0",
            "type" => "text");
        $of_options[] = array("name" => esc_html__("Footer Bottom Margin", 'organicfood'),
            "desc" => esc_html__("In pixels, top left botton right, ex: 10px 10px 10px 10px", 'organicfood'),
            "id" => "footer_bottom_margin",
            "std" => "0",
            "type" => "text");
/*Section Styling Options*/
        $of_options[] = array("name" => esc_html__("Styling Options", 'organicfood'),
            "type" => "heading"
        );

        $of_options[] = array("name" => esc_html__("Main Color", 'organicfood'),
            "desc" => "",
            "id" => "main_color",
            "std" => "<h3>".esc_html__("Main Color", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array("name" => esc_html__("Preset Color Scheme", 'organicfood'),
            "desc" => esc_html__("Select a scheme, all color options will automatically change to the defined scheme.", 'organicfood'),
            "id" => "preset_color_scheme",
            "std" => "preset1",
            "type" => "select",
            "options" => array('preset1' => 'Preset1', 'preset2' => 'Preset2', 'preset3' => 'Preset3', 'preset4' => 'Preset4', 'preset5' => 'Preset5', 'preset6' => 'Preset6', 'preset7' => 'Preset7', 'preset8' => 'Preset8', 'preset9' => 'Preset9', 'preset10' => 'Preset10'));
        $of_options[] = array("name" => esc_html__("Primary Color", 'organicfood'),
            "desc" => esc_html__("Controls several items, ex: link hovers, highlights, and more.", 'organicfood'),
            "id" => "primary_color",
            "std" => "#69bd43",
            "type" => "color");
        $of_options[] = array("name" => esc_html__("Heading Color", 'organicfood'),
            "desc" => esc_html__("Heading Color.", 'organicfood'),
            "id" => "heading_color",
            "std" => "#666666",
            "type" => "color");
        $of_options[] = array("name" => esc_html__("Link Color", 'organicfood'),
            "desc" => esc_html__("Controls the color of all text links.", 'organicfood'),
            "id" => "link_color",
            "std" => "#69bd43",
            "type" => "color");
        $of_options[] = array("name" => esc_html__("Link Color Hover", 'organicfood'),
            "desc" => esc_html__("Link Color Hover.", 'organicfood'),
            "id" => "link_color_hover",
            "std" => "#3f7228",
            "type" => "color");

        $of_options[] = array("name" => esc_html__("Button Text Color", 'organicfood'),
            "desc" => esc_html__("Controls the text color of buttons.", 'organicfood'),
            "id" => "button_text_color",
            "std" => "#fff",
            "type" => "color");
        /*$of_options[] = array("name" => esc_html__("Button Background Color", 'organicfood'),
            "desc" => esc_html__("Controls the Background color of buttons.", 'organicfood'),
            "id" => "button_bg_color",
            "std" => "#fff",
            "type" => "color");*/
        $of_options[] = array("name" => esc_html__("Button Background Color hover", 'organicfood'),
            "desc" => esc_html__("Controls the Background color hover of buttons.", 'organicfood'),
            "id" => "button_bg_color_hover",
            "std" => "#3f7228",
            "type" => "color");
        $of_options[] = array("name" => esc_html__("Background Color", 'organicfood'),
            "desc" => esc_html__("Select a background color.", 'organicfood'),
            "id" => "bg_color",
            "std" => "#fff",
            "type" => "color");
        $of_options[] = array("name" => esc_html__("Body Text Color", 'organicfood'),
            "desc" => esc_html__("Controls the text color of body font.", 'organicfood'),
            "id" => "body_text_color",
            "std" => "#666666",
            "type" => "color");
        $of_options[] = array("name" => esc_html__("Main Menu Colors", 'organicfood'),
            "desc" => "",
            "id" => "main_menu_colors",
            "std" => "<h3>".esc_html__("Main Menu Colors", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array("name" => esc_html__("Main Menu Font Color - First Level", 'organicfood'),
            "desc" => esc_html__("Controls the text color of first level menu items.", 'organicfood'),
            "id" => "menu_first_color",
            "std" => "#999999",
            "type" => "color");

        $of_options[] = array("name" => esc_html__("Main Menu Font Hover Color - First Level", 'organicfood'),
            "desc" => esc_html__("Controls the main menu hover, hover border & dropdown border color.", 'organicfood'),
            "id" => "menu_hover_first_color",
            "std" => "#ffffff",
            "type" => "color");

        $of_options[] = array("name" => esc_html__("Main Menu Background Color - Sublevels", 'organicfood'),
            "desc" => esc_html__("Controls the color of the menu sublevel background.", 'organicfood'),
            "id" => "menu_sub_bg_color",
            "std" => "#ffffff",
            "type" => "color");

        $of_options[] = array("name" => esc_html__("Main Menu Background Hover Color - Sublevels", 'organicfood'),
            "desc" => esc_html__("Controls the hover color of the menu sublevel background.", 'organicfood'),
            "id" => "menu_bg_hover_color",
            "std" => "#f5f7f9",
            "type" => "color");

        $of_options[] = array("name" => esc_html__("Main Menu Font Color - Sublevels", 'organicfood'),
            "desc" => esc_html__("Controls the color of the menu font sublevels.", 'organicfood'),
            "id" => "menu_sub_color",
            "std" => "#afb4b9",
            "type" => "color");

        $of_options[] = array("name" => esc_html__("Main Menu Font Hover Color - Sublevels", 'organicfood'),
            "desc" => esc_html__("Controls the color of the menu font sublevels.", 'organicfood'),
            "id" => "menu_sub_hover_color",
            "std" => "#999",
            "type" => "color");

        $of_options[] = array("name" => esc_html__("Main Menu Separator - Sublevels", 'organicfood'),
            "desc" => esc_html__("Controls the color of the menu separator sublevels.", 'organicfood'),
            "id" => "menu_sub_sep_color",
            "std" => "#eff4f7",
            "type" => "color");
        // end menu
    // begin header color option
        $of_options[] = array("name" => esc_html__("Header Color Option", 'organicfood'),
            "desc" => "",
            "id" => "header_color_option",
            "std" => "<h3>".esc_html__("Header Color Option", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array("name" => esc_html__("Header Background Color", 'organicfood'),
            "desc" => esc_html__("Header Background Color.", 'organicfood'),
            "id" => "header_bg_color",
            "std" => "#FFFFFF",
            "type" => "color");
        $of_options[] = array("name" => esc_html__("Header Sticky Background Color", 'organicfood'),
            "desc" => esc_html__("Header Sticky Background Color.", 'organicfood'),
            "id" => "header_sticky_bg_color",
            "std" => "#FFFFFF",
            "type" => "color");
    //begin title bar color option
    $of_options[] = array("name" => esc_html__("Title Bar Color Option", 'organicfood'),
            "desc" => "",
            "id" => "title_bar_color_option",
            "std" => "<h3>".esc_html__("Title Bar Color Option", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
    $of_options[] = array("name" => esc_html__("Title Bar Background Color", 'organicfood'),
            "desc" => esc_html__("Title Bar Background Color.", 'organicfood'),
            "id" => "title_bar_bg_color",
            "std" => "#f2f2f2",
            "type" => "color");
    $of_options[] = array("name" => esc_html__("Title Bar Heading Color", 'organicfood'),
            "desc" => esc_html__("Heading Color.", 'organicfood'),
            "id" => "title_bar_heading_color",
            "std" => "#666666",
            "type" => "color");
    $of_options[] = array("name" => esc_html__("Title Bar Text Color", 'organicfood'),
            "desc" => esc_html__("Controls the color of all text.", 'organicfood'),
            "id" => "title_bar_text_color",
            "std" => "#666666",
            "type" => "color");
    $of_options[] = array("name" => esc_html__("Title Bar Link Color", 'organicfood'),
            "desc" => esc_html__("Controls the color of all text links.", 'organicfood'),
            "id" => "title_bar_link_color",
            "std" => "#69bd43",
            "type" => "color");
    $of_options[] = array("name" => esc_html__("Title Bar Link Color Hover", 'organicfood'),
            "desc" => esc_html__("Controls the color of all text links hover.", 'organicfood'),
            "id" => "title_bar_link_color_hover",
            "std" => "#3f7228",
            "type" => "color");
    // begin footer color option
        $of_options[] = array("name" => esc_html__("Footer Color Option", 'organicfood'),
            "desc" => "",
            "id" => "footer_color_option",
            "std" => "<h3>".esc_html__("Footer Color Option", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array("name" => esc_html__("Footer Top Background Color", 'organicfood'),
            "desc" => esc_html__("Footer Top Background Color.", 'organicfood'),
            "id" => "footer_top_bg_color",
            "std" => "#000000",
            "type" => "color");
        $of_options[] = array("name" => esc_html__("Footer Bottom Background Color", 'organicfood'),
            "desc" => esc_html__("Footer Bottom Background Color.", 'organicfood'),
            "id" => "footer_bottom_bg_color",
            "std" => "#000000",
            "type" => "color");
        $of_options[] = array("name" => esc_html__("Footer Headings Color", 'organicfood'),
            "desc" => esc_html__("Controls the text color of the footer heading font.", 'organicfood'),
            "id" => "footer_headings_color",
            "std" => "#999",
            "type" => "color");
        $of_options[] = array("name" => esc_html__("Footer Font Color", 'organicfood'),
            "desc" => esc_html__("Controls the text color of the footer font.", 'organicfood'),
            "id" => "footer_text_color",
            "std" => "#fff",
            "type" => "color");
        $of_options[] = array("name" => esc_html__("Footer Link Color", 'organicfood'),
            "desc" => esc_html__("Controls the text color of the footer link font.", 'organicfood'),
            "id" => "footer_link_color",
            "std" => "#00c3b6",
            "type" => "color");
        $of_options[] = array("name" => esc_html__("Footer Link Hover Color", 'organicfood'),
            "desc" => esc_html__("Footer Link Hover Color.", 'organicfood'),
            "id" => "footer_link_hover_color",
            "std" => "#fff",
            "type" => "color");
        // end footer color option

/*Section Typography*/
        $of_options[] = array("name" => esc_html__("Typography", 'organicfood'),
            "type" => "heading"
        );

        $of_options[] = array("name" => esc_html__("Body Options", 'organicfood'),
            "desc" => "",
            "id" => "body_options",
            "std" => "<h3>".esc_html__("Body Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array("name" => esc_html__("Body Font Options", 'organicfood'),
            "desc" => esc_html__("Body Font Options.", 'organicfood'),
            "id" => "body_font_options",
            "std" => "Standard Font",
            "type" => "select",
            "options" => $of_options_font
        );
        $of_options[] = array("name" => esc_html__("Google Body Font Family", 'organicfood'),
            "desc" => esc_html__("Google body font family.", 'organicfood'),
            "id" => "google_body_font_family",
            "std" => "",
            "type" => "select",
            "options" => $of_options_google_font
        );
        $of_options[] = array("name" => esc_html__("Standard Body Font Family", 'organicfood'),
            "desc" => esc_html__("Standard Body Font Family.", 'organicfood'),
            "id" => "standard_body_font_family",
            "std" => "Arial, Helvetica, sans-serif",
            "type" => "select",
            "options" => $of_options_standard_fonts
        );
        $of_options[] = array("name" => esc_html__("Custom Body Font Family", 'organicfood'),
            "desc" => esc_html__("Custom Body Font Family.", 'organicfood'),
            "id" => "custom_body_font_family",
            "std" => "",
            "type" => "select",
            "options" => $of_options_custom_fonts
        );

        $of_options[] = array("name" => esc_html__("Body Font Family Selector", 'organicfood'),
            "desc" => esc_html__("Body Font Family Selector", 'organicfood'),
            "id" => "body_font_family_selector",
            "std" => "body",
            "type" => "textarea"
        );
        $of_options[] = array("name" => esc_html__("Body Font Size", 'organicfood'),
            "desc" => esc_html__("Body Font Size", 'organicfood'),
            "id" => "body_font_size",
            "std" => "14px",
            "type" => "select",
            "options" => $of_options_fontsize
        );

        $of_options[] = array("name" => esc_html__("Other Options", 'organicfood'),
            "desc" => "",
            "id" => "other_options",
            "std" => "<h3>".esc_html__("Other Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        /* Other Font 0 */
        $of_options[] = array("name" => esc_html__("Other Font Options", 'organicfood'),
            "desc" => esc_html__("Other Font Options.", 'organicfood'),
            "id" => "other_font_options_0",
            "std" => "Custom Font",
            "type" => "select",
            "options" => $of_options_font
        );
        $of_options[] = array("name" => esc_html__("Google Other Font Family", 'organicfood'),
            "desc" => esc_html__("Google Other font family.", 'organicfood'),
            "id" => "google_other_font_family_0",
            "std" => "",
            "type" => "select",
            "options" => $of_options_google_font
        );
        $of_options[] = array("name" => esc_html__("Standard Other Font Family", 'organicfood'),
            "desc" => esc_html__("Standard Other Font Family.", 'organicfood'),
            "id" => "standard_other_font_family_0",
            "std" => "",
            "type" => "select",
            "options" => $of_options_standard_fonts
        );
        $of_options[] = array("name" => esc_html__("Custom Other Font Family", 'organicfood'),
        		"desc" => esc_html__("Custom Other Font Family.", 'organicfood'),
        		"id" => "custom_other_font_family_0",
        		"std" => "Custom Font",
        		"type" => "select",
        		"options" => $of_options_custom_fonts
        );
        $of_options[] = array("name" => esc_html__("Other Font Family Selector", 'organicfood'),
        		"desc" => esc_html__("Other Font Family Selector", 'organicfood'),
        		"id" => "other_font_family_selector_0",
        		"std" => ".page-title-style .page-title, h3.cs-pricing-title, .comment-body .fn, .home .ww-fancy-box .ww-title-main",
        		"type" => "textarea"
        );
        /* End Other Font*/
// end Typography

/*Section Blog*/
        $of_options[] = array("name" => esc_html__("Blog", 'organicfood'),
            "type" => "heading"
        );
        $of_options[] = array("name" => esc_html__("Blog Title Bar Options", 'organicfood'),
            "desc" => "",
            "id" => "blog_title_bar_options",
            "std" => "<h3>".esc_html__("Blog Title Bar Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array("name" => esc_html__("Background", 'organicfood'),
            "desc" => esc_html__("Select an image file for your background title bar.", 'organicfood'),
            "id" => "background_title_bar_blog",
            "std" => URI_PATH . "/images/TitleBarbg3.jpg",
            "mod" => "",
            "type" => "media");
        $of_options[] = array(  "name" => esc_html__("Background Size", 'organicfood'),
            "desc"      => esc_html__("Select background size for your background title bar.", 'organicfood'),
            "id"        => "background_size_title_bar_blog",
            "std"       => "auto auto",
            "type" => "select",
            "options" => $body_size);
        $of_options[] = array(  "name" => esc_html__("Background Position", 'organicfood'),
            "desc"      => esc_html__("Select background position for your background title bar.", 'organicfood'),
            "id"        => "background_position_title_bar_blog",
            "std"       => "top left",
            "type" => "select",
            "options" => $body_pos);
        $of_options[] = array(  "name" => esc_html__("Background Repeat", 'organicfood'),
            "desc"      => esc_html__("Select background repeat for your background title bar.", 'organicfood'),
            "id"        => "background_repeat_title_bar_blog",
            "std"       => "repeat",
            "type" => "select",
            "options" => $body_repeat);
        $of_options[] = array( "name" => esc_html__("Padding", 'organicfood'),
            "desc" => esc_html__("Padding of title bar.", 'organicfood'),
            "id" => "padding_title_bar_blog",
            "std" => "40px 0",
            "type" => "text");
        $of_options[] = array( "name" => esc_html__("Margin", 'organicfood'),
            "desc" => esc_html__("margin of title bar.", 'organicfood'),
            "id" => "margin_title_bar_blog",
            "std" => "0 0 20px 0",
            "type" => "text");
        $of_options[] = array( "name" => esc_html__("Show Page Title", 'organicfood'),
            "desc" => esc_html__("Show Page Title", 'organicfood'),
            "id" => "show_page_title_blog",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $of_options[] = array( "name" => esc_html__("Show Page Breadcrumb", 'organicfood'),
            "desc" => esc_html__("Show Page Breadcrumb", 'organicfood'),
            "id" => "show_page_breadcrumb_blog",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $of_options[] = array( "name" => esc_html__("Delimiter", 'organicfood'),
            "desc" => esc_html__("Delimiter of page breadcrumb.", 'organicfood'),
            "id" => "delimiter_page_breadcrumb_blog",
            "std" => "/",
            "type" => "text",
            "fold" => "show_page_breadcrumb_blog");
        $of_options[] = array("name" => esc_html__("Blog Options", 'organicfood'),
            "desc" => "",
            "id" => "blog_options",
            "std" => "<h3>".esc_html__("Blog Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array( "name" => esc_html__("Show Info Blog", 'organicfood'),
            "desc" => esc_html__("Show Info Blog", 'organicfood'),
            "id" => "show_info_blog",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $url =  ADMIN_DIR . 'assets/images/';
        $of_options[] = array(  "name"      => esc_html__("Blog Layout", 'organicfood'),
            "desc"      => esc_html__("Select main content and sidebar alignment. Choose between 1, 2 or 3 column layout.", 'organicfood'),
            "id"        => "blog_layout",
            "std"       => "right-fixed",
            "type"      => "images",
            "options"   => array(
                    'full-fixed'    => $url . '1col.png',
                    'right-fixed'   => $url . '2cr.png',
                    'left-fixed'    => $url . '2cl.png'
            )
        );
        $of_options[] = array( "name" => esc_html__("Excerpt Length", 'organicfood'),
            "desc" => esc_html__("Insert the number of words you want to show in the post excerpts.", 'organicfood'),
            "id" => "blog_excerpt_length_blog",
            "std" => "50",
            "type" => "text");
        $of_options[] = array( "name" => esc_html__("Excerpt More", 'organicfood'),
            "desc" => esc_html__("Insert the character of words you want to show in the post excerpts.", 'organicfood'),
            "id" => "blog_excerpt_more_blog",
            "std" => "...",
            "type" => "text");
        $of_options[] = array("name" => esc_html__("Post Options", 'organicfood'),
            "desc" => "",
            "id" => "post_options",
            "std" => "<h3>".esc_html__("Post Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array( "name" => esc_html__("Show Title Post", 'organicfood'),
            "desc" => esc_html__("Show Title Post", 'organicfood'),
            "id" => "show_title_post",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $of_options[] = array( "name" => esc_html__("Show Info Post", 'organicfood'),
            "desc" => esc_html__("Show Info Post", 'organicfood'),
            "id" => "show_info_post",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $of_options[] = array( "name" => esc_html__("Show Comments Post", 'organicfood'),
            "desc" => esc_html__("Show Comments Post", 'organicfood'),
            "id" => "show_comments_post",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $of_options[] = array( "name" => esc_html__("Show Tags", 'organicfood'),
            "desc" => esc_html__("Show Tags Post", 'organicfood'),
            "id" => "show_tags_post",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $of_options[] = array( "name" => esc_html__("Previous/Next Pagination", 'organicfood'),
            "desc" => esc_html__("Previous/Next Pagination", 'organicfood'),
            "id" => "show_navigation_post",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");
        $of_options[] = array(  "name"      => esc_html__("Post Layout", 'organicfood'),
            "desc"      => esc_html__("Select main content and sidebar alignment. Choose between 1, 2 or 3 column layout.", 'organicfood'),
            "id"        => "post_layout",
            "std"       => "right-fixed",
            "type"      => "images",
            "options"   => array(
                'full-fixed'    => $url . '1col.png',
                'right-fixed'   => $url . '2cr.png',
                'left-fixed'    => $url . '2cl.png',
                '3column-fixed'         => $url . '3cm.png',
                '3column-right-fixed'   => $url . '3cr.png'
            )
        );
        $of_options[] = array("name" => esc_html__("Page Options", 'organicfood'),
            "desc" => "",
            "id" => "page_options",
            "std" => "<h3>".esc_html__("Page Options", 'organicfood')."</h3>",
            "icon" => true,
            "type" => "info");
        $of_options[] = array( "name" => esc_html__("Show Comments Page", 'organicfood'),
            "desc" => esc_html__("Show Comments Page", 'organicfood'),
            "id" => "show_comments_page",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch");

/*Section Woo*/   
    if (class_exists('Woocommerce')) {     
        $of_options[] = array("name" => esc_html__("Woocommerce", 'organicfood'),
            "type" => "heading"
        );
        $of_options[] = array(
            "name" => esc_html__("Layout", 'organicfood'),
            "desc" => esc_html__("Left / Right sidebar", 'organicfood'),
            "id" => "loop_left_right_sidebar",
            "std" => "right",
            "options" => array(
                'left' => esc_html__("Left", 'organicfood'), 
                'right' => esc_html__("Right", 'organicfood'), 
                'full' => esc_html__("Full", 'organicfood')
            ),
            "type" => "select"
        );
        $of_options[] = array(
            "name" => esc_html__("Shop loop columns xl", 'organicfood'),
            "desc" => esc_html__("Enter the Shop loop columns xl", 'organicfood'),
            "id" => "shop_loop_col_xl",
            "std" => "4",
            "options" => array('4' => '4', '3' => '3', '2' => '2', '5' => '5', '6' => '6'),
            "type" => "select"
        );
        $of_options[] = array(
            "name" => esc_html__("Shop loop columns lg", 'organicfood'),
            "desc" => esc_html__("Enter the Shop loop columns lg", 'organicfood'),
            "id" => "shop_loop_col_lg",
            "std" => "3",
            "options" => array('3' => '3', '2' => '2', '1' => '1', '4' => '4'),
            "type" => "select"
        );
        $of_options[] = array(
            "name" => esc_html__("Shop loop columns md", 'organicfood'),
            "desc" => esc_html__("Enter the Shop loop columns md", 'organicfood'),
            "id" => "shop_loop_col_md",
            "std" => "3",
            "options" => array('2' => '2', '3' => '3', '4' => '4', '1' => '1', ),
            "type" => "select"
        );
        $of_options[] = array(
            "name" => esc_html__("Shop loop columns sm", 'organicfood'),
            "desc" => esc_html__("Enter the Shop loop columns sm", 'organicfood'),
            "id" => "shop_loop_col_sm",
            "std" => "2",
            "options" => array('1' => '1', '2' => '2', '3' => '3'),
            "type" => "select"
        );
        $of_options[] = array(
            "name" => esc_html__("Shop loop columns xs", 'organicfood'),
            "desc" => esc_html__("Enter the Shop loop columns xs", 'organicfood'),
            "id" => "shop_loop_col_xs",
            "std" => "1",
            "options" => array('1' => '1', '2' => '2'),
            "type" => "select"
        ); 
        $of_options[] = array(
            "name" => esc_html__("Single gallery columns", 'organicfood'),
            "desc" => esc_html__("Enter the number of column", 'organicfood'),
            "id" => "single_gallery_columns",
            "std" => "3",
            "options" => array('2' => '2', '3' => '3','4' => '4'),
            "type" => "select"
        ); 
        $of_options[] = array( "name" => esc_html__("Show Single product upsell", 'organicfood'),
            "desc" => esc_html__("Show or hide single product upsell", 'organicfood'),
            "id" => "show_product_upsell",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch"
        );
        $of_options[] = array( "name" => esc_html__("Show Single product related", 'organicfood'),
            "desc" => esc_html__("Show or hide single product related", 'organicfood'),
            "id" => "show_product_related",
            "std" => 1,
            "on" => "Yes",
            "off" => "No",
            "type" => "switch"
        );
    }
/*Section Custom CSS*/
        $of_options[] = array("name" => esc_html__("Custom CSS", 'organicfood'),
            "type" => "heading"
        );
        $of_options[] = array("name" => esc_html__("Custom CSS", 'organicfood'),
            "desc" => esc_html__("Quickly add some CSS to your theme by adding it to this block.", 'organicfood'),
            "id" => "custom_css",
            "std" => "",
            "type" => "textarea"
        );
/*Section Backup Options*/
        $of_options[] = array("name" => esc_html__("Backup Options", 'organicfood'),
            "type" => "heading",
            "icon" => ADMIN_IMAGES . "icon-slider.png"
        );
        $of_options[] = array("name" => esc_html__("Backup and Restore Options", 'organicfood'),
            "id" => "of_backup",
            "std" => "",
            "type" => "backup",
            "desc" => esc_html__('You can use the two buttons below to backup your current options, and then restore it back at a later time. This is useful if you want to experiment on the options but would like to keep the old settings in case you need it back.', 'organicfood'),
        );

        $of_options[] = array("name" => esc_html__("Transfer Theme Options Data", 'organicfood'),
            "id" => "of_transfer",
            "std" => "",
            "type" => "transfer",
            "desc" => esc_html__('You can tranfer the saved options data between different installs by copying the text inside the text box. To import data from another install, replace the data in the text box with the one from another install and click "Import Options".', 'organicfood'),
        );

    }
}
?>
