<?php
foreach (glob("".get_template_directory()."/framework/includes/vc_extra_shortcodes/*.php") as $filename)
{
	include $filename;
}
// intergrate VC
add_action ( 'init', 'cs_integrateWithVC' );
function cs_integrateWithVC() {
	$vc_is_wp_version_3_6_more = version_compare ( preg_replace ( '/^([\d\.]+)(\-.*$)/', '$1', get_bloginfo ( 'version' ) ), '3.6' ) >= 0;
	/*
	 * Tabs ----------------------------------------------------------
	 */
	$tab_id_1 = time () . '-1-' . rand ( 0, 100 );
	$tab_id_2 = time () . '-2-' . rand ( 0, 100 );
	vc_map ( array (
			"name" => esc_html__( 'Tabs', 'organicfood' ),
			'base' => 'vc_tabs',
			'show_settings_on_create' => false,
			'is_container' => true,
			'icon' => 'icon-wpb-ui-tab-content',
			'category' => esc_html__( 'Content', 'organicfood' ),
			'description' => esc_html__( 'Tabbed content', 'organicfood' ),
			'params' => array (
					array (
							'type' => 'textfield',
							'heading' => esc_html__( 'Widget title', 'organicfood' ),
							'param_name' => 'title',
							'description' => esc_html__( 'Enter text which will be used as widget title. Leave blank if no title is needed.', 'organicfood' )
					),
					array (
							'type' => 'dropdown',
							'heading' => esc_html__( 'Auto rotate tabs', 'organicfood' ),
							'param_name' => 'interval',
							'value' => array (
									esc_html__( 'Disable', 'organicfood' ) => 0,
									3,
									5,
									10,
									15
							),
							'std' => 0,
							'description' => esc_html__( 'Auto rotate tabs each X seconds.', 'organicfood' )
					),
					array (
							'type' => 'textfield',
							'heading' => esc_html__( 'Extra class name', 'organicfood' ),
							'param_name' => 'el_class',
							'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'organicfood' )
					),
					array (
							'type' => 'dropdown',
							'param_name' => 'style',
							'heading' => esc_html__( 'Style', 'organicfood' ),
							'value' => array (
									"Default" => "style2",
									"Square" => "style1",
									"Verticle Tab" => "style3"
							),
							'std' => 'style1',
							'description' => esc_html__( '', 'organicfood' )
					)
			),
			'custom_markup' => '
	<div class="wpb_tabs_holder wpb_holder vc_container_for_children">
	<ul class="tabs_controls">
	</ul>
	%content%
	</div>',
			'default_content' => '
	[vc_tab title="' . esc_html__( 'Tab 1', 'organicfood' ) . '" tab_id="' . $tab_id_1 . '"][/vc_tab]
	[vc_tab title="' . esc_html__( 'Tab 2', 'organicfood' ) . '" tab_id="' . $tab_id_2 . '"][/vc_tab]
	',
			'js_view' => $vc_is_wp_version_3_6_more ? 'VcTabsView' : 'VcTabsView35'
	) );
        vc_map( array(
            'name' => esc_html__( 'Tab', 'organicfood' ),
            'base' => 'vc_tab',
            'allowed_container_element' => 'vc_row',
            'is_container' => true,
            'content_element' => false,
            'params' => array(
                    array(
                            'type' => 'textfield',
                            'heading' => esc_html__( 'Title', 'organicfood' ),
                            'param_name' => 'title',
                            'description' => esc_html__( 'Tab title.', 'organicfood' )
                    ),
                    array(
                            'type' => 'textfield',
                            'heading' => esc_html__( 'Icon', 'organicfood' ),
                            'param_name' => 'icon',
                            'description' => esc_html__( 'Icon class.', 'organicfood' )
                    ),
                    array(
                            'type' => 'tab_id',
                            'heading' => esc_html__( 'Tab ID', 'organicfood' ),
                            'param_name' => "tab_id"
                    )
            ),
            'js_view' => $vc_is_wp_version_3_6_more ? 'VcTabView' : 'VcTabView35'
    ) );
	
}