<?php

if(!class_exists('CMSMetaOptionsBase')) return;
class CsheroFrameworkMetaboxes extends CMSMetaOptionsBase
{
	 
	public function __construct(){
     	parent::__construct();
    }

	 
	public function cms_add_mtbs(){
		//$post_types = get_post_types( array( 'public' => true ) );
        $this->cms_add_mtb('post_options', esc_html__('Page Options', 'organicfood'), 'page');
        $this->cms_add_mtb('post_video', esc_html__('Video Settings','organicfood'), 'post');
		$this->cms_add_mtb('post_audio', esc_html__('Audio Settings','organicfood'), 'post');
		$this->cms_add_mtb('post_quote', esc_html__('Quote Settings','organicfood'), 'post');
		$this->cms_add_mtb('post_link', esc_html__('Link Settings','organicfood'), 'post');
  
    }
  
	public function post_options()
	{
		$data = $this->data;
		include 'views/metaboxes/blog_options.php';
	}
	public function post_video()
	{
		include 'views/metaboxes/post_video.php';
	}
	public function post_audio()
	{
		include 'views/metaboxes/post_audio.php';
	}
	public function post_quote()
	{
		include 'views/metaboxes/post_quote.php';
	}
	public function post_link()
	{
		include 'views/metaboxes/post_link.php';
	}
	public function text($id, $label, $default, $desc = '')
	{
		global $post;
		$value = get_post_meta($post->ID, 'cs_' . $id, true);
		if (!$value){
			$value = $default;
		}
		$html = '';
		$html .= '<div id="cs_metabox_field_'.$id.'" class="cs_metabox_field">';
		$html .= '<label for="cs_' . $id . '">';
		$html .= $label;
		$html .= '</label>';
		$html .= '<div class="field">';
		$html .= '<input type="text" id="cs_' . $id . '" name="cs_' . $id . '" value="' . $value . '" />';
		if($desc) {
			$html .= '<p>' . $desc . '</p>';
		}
		$html .= '</div>';
		$html .= '</div>';

		echo ''.$html;
	}
	public function hidden($id){
		global $post;
		$html = '<input type="hidden" id="cs_' . $id . '" name="cs_' . $id . '" value="' . get_post_meta($post->ID, 'cs_' . $id, true) . '" />';
		echo ''.$html;
	}
	public function select($id, $label, $options,$defualt, $desc = '')
	{
		global $post;

		$html = '';
		$html .= '<div id="cs_metabox_field_'.$id.'" class="cs_metabox_field">';
		$html .= '<label for="cs_' . $id . '">';
		$html .= $label;
		$html .= '</label>';
		$html .= '<div class="field">';
		$html .= '<select id="cs_' . $id . '" name="cs_' . $id . '">';
                
                $value = get_post_meta($post->ID, 'cs_' . $id, true);
		$defualt = $value == '' ? $defualt ='global': $value;
                
		foreach($options as $key => $option) {
                    $selected = $defualt === (string)$key?'selected="selected"':null;
                    $html .= '<option ' . $selected . 'value="' . $key . '">' . $option . '</option>';
		}
		$html .= '</select>';
		if($desc) {
			$html .= '<p>' . $desc . '</p>';
		}
		$html .= '</div>';
		$html .= '</div>';

		echo ''.$html;
	}

	public function multiple($id, $label, $options, $desc = '')
	{
		global $post;

		$html = '';
		$html .= '<div id="cs_metabox_field_'.$id.'" class="cs_metabox_field">';
		$html .= '<label for="cs_' . $id . '">';
		$html .= $label;
		$html .= '</label>';
		$html .= '<div class="field">';
		$html .= '<select multiple="multiple" id="cs_' . $id . '" name="cs_' . $id . '[]">';
		foreach($options as $key => $option) {
			if(is_array(get_post_meta($post->ID, 'cs_' . $id, true)) && in_array($key, get_post_meta($post->ID, 'cs_' . $id, true))) {
				$selected = 'selected="selected"';
			} else {
				$selected = '';
			}

			$html .= '<option ' . $selected . 'value="' . $key . '">' . $option . '</option>';
		}
		$html .= '</select>';
		if($desc) {
			$html .= '<p>' . $desc . '</p>';
		}
		$html .= '</div>';
		$html .= '</div>';

		echo ''.$html;
	}

	public function textarea($id, $label, $desc = '')
	{
		global $post;

		$html = '';
		$html = '';
		$html .= '<div id="cs_metabox_field_'.$id.'" class="cs_metabox_field">';
		$html .= '<label for="cs_' . $id . '">';
		$html .= $label;
		$html .= '</label>';
		$html .= '<div class="field">';
		$html .= '<textarea cols="30" rows="5" id="cs_' . $id . '" name="cs_' . $id . '">' . get_post_meta($post->ID, 'cs_' . $id, true) . '</textarea>';
		if($desc) {
			$html .= '<p>' . $desc . '</p>';
		}
		$html .= '</div>';
		$html .= '</div>';

		echo ''.$html;
	}

	public function upload($id, $label, $desc = '')
	{
		global $post;

		$html = '';
		$html = '';
		$html .= '<div id="cs_metabox_field_'.$id.'" class="cs_metabox_field">';
		$html .= '<label for="cs_' . $id . '">';
		$html .= $label;
		$html .= '</label>';
		$html .= '<div class="field">';
		$html .= '<input name="cs_' . $id . '" class="upload_field" id="cs_' . $id . '" type="text" value="' . get_post_meta($post->ID, 'cs_' . $id, true) . '" />';
		$html .= '<input class="cshero_upload_button button button-primary button-large" type="button" value="Browse" />';
		if($desc) {
			$html .= '<p>' . $desc . '</p>';
		}
		$html .= '</div>';
		$html .= '</div>';

		echo ''.$html;
	}
 

}
$metaboxes = new CsheroFrameworkMetaboxes;