<?php
function ww_shortcode_piegraph_render($atts, $content = null) {
    global $post, $wp_query;
    extract(shortcode_atts(array(
            'title' => '',
            'percent' => 0,
            'radius' => 100,
            'color' => '#FFF',
            'el_class' => ''
    ), $atts));
    $date = 'd'. time() . '_' . uniqid(true);
    ob_start();
    ?>
        <div class="pie-graph <?php echo esc_attr($el_class);?>" data-id="percent_loader<?php echo esc_attr($date); ?>" data-percent="<?php echo esc_attr($percent);?>" data-radius="<?php echo esc_attr($radius);?>" data-color="<?php echo esc_attr($color);?>">
            <canvas id="percent_loader<?php echo esc_attr($date); ?>" class="percent_loader" width="<?php echo esc_attr($radius*2);?>" height="<?php echo esc_attr($radius*2); ?>"></canvas>
            <h3><?php echo esc_html($title);?></h3>
        </div>
    <?php
    return ob_get_clean();
}

if(function_exists('insert_shortcode')) { insert_shortcode('ww-shortcode-piegraph', 'ww_shortcode_piegraph_render'); }
