<?php
/**
 * Enable Export Sample Data 
*/
if(!function_exists('wp_organicfood_enable_create_demo')){
    add_filter('ef5_ie_export_mode', 'wp_organicfood_enable_create_demo');
    function wp_organicfood_enable_create_demo() {
        return false;
    }
}

add_filter('ef5_ie_options_name', 'wp_organicfood_set_demo_opt_name');

function wp_organicfood_set_demo_opt_name(){
    return 'opt_theme_options';
}

function wp_organicfood_update_theme_option(){
    if(!function_exists('base64_cms_decode')) return;
    $option_json = get_template_directory_uri() . '/inc/demo-data/1/option.txt';
    $option_json = wp_remote_get( $option_json );
    $option_data = $option_json['body'];
    of_save_options(unserialize(base64_cms_decode($option_data))); 
}

add_action('ef5-ie-import-finish', 'wp_organicfood_update_theme_option');

function wp_organicfood_set_home_page(){

    $home_page = 'Organic Home';

    $page = get_page_by_title($home_page);

    if(!isset($page->ID))

        return ;
         
        update_option('show_on_front', 'page');
        update_option('page_on_front', $page->ID);
}

add_action('ef5-ie-import-finish', 'wp_organicfood_set_home_page');

function wp_organicfood_import_grid(){

    if(!function_exists('file_cms_get_contents')) return;

    if(file_exists(ABSPATH .'wp-content/plugins/essential-grid/admin/includes/import.class.php')){

        require_once(ABSPATH .'wp-content/plugins/essential-grid/admin/includes/import.class.php');
         
        $folder_dir = trailingslashit(get_template_directory().'/inc/demo-data/1/grid');

        if(!file_exists($folder_dir . '/ess_grid.json')) exit();

        $im = new Essential_Grid_Import();

        $grid_extract = json_decode(file_cms_get_contents($folder_dir . '/ess_grid.json'), true); 
        $grids = $grid_extract['grids'];

        if(!empty($grids) && is_array($grids)){

            $grids_imported = $im->import_grids($grids);
        }
    } 
}

add_action('ef5-ie-import-finish', 'wp_organicfood_import_grid');

function wp_organicfood_set_menu_location(){

    $setting = array(
            'Main Menu' => 'main_navigation'
    );

    $navs = wp_get_nav_menus();

    $new_setting = array();

    foreach ($navs as $nav){

        if(!isset($setting[$nav->name]))
            continue;

            $id = $nav->term_id;
            $location = $setting[$nav->name];

            $new_setting[$location] = $id;
    }

    set_theme_mod('nav_menu_locations', $new_setting);
}
 
add_action('ef5-ie-import-finish', 'wp_organicfood_set_menu_location');

function wp_organicfood_set_woo_page(){    

    $pages = array(
        
        'woocommerce_shop_page_id'      => 'Shop',
        'woocommerce_cart_page_id'      => 'Cart',
        'woocommerce_checkout_page_id'  => 'Checkout'         
    );
    foreach ($pages as $key => $page){
        $page = get_page_by_title($page);
        if(!isset($page->ID))
            return ;
        update_option($key, $page->ID);
    }

}
add_action('ef5-ie-import-finish', 'wp_organicfood_set_woo_page');

/**
 * Get post ID by Title 
 * @return ID
*/
function organicfood_get_id_by_title($post_title, $post_type = 'page'){
    $page = get_page_by_title( $post_title, OBJECT , $post_type );
    if(isset($page->ID))
        return $page->ID;
    else 
        return 0;
}

add_action('ef5-ie-import-start', 'wp_eagleeyes_move_trash', 1);
if(!function_exists('wp_eagleeyes_move_trash')){
    function wp_eagleeyes_move_trash(){
        wp_trash_post(1);
        wp_trash_post(2);
        wp_trash_post(3);
        wp_trash_post(organicfood_get_id_by_title('Shop'));
        wp_trash_post(organicfood_get_id_by_title('Cart'));
        wp_trash_post(organicfood_get_id_by_title('Checkout'));
        wp_trash_post(organicfood_get_id_by_title('My Account'));

    }
}