<?php 
/**
 * Remove all default WC css
*/
add_filter( 'woocommerce_enqueue_styles', 'organicfood_woo_style' );
function organicfood_woo_style($arr){
	unset($arr['woocommerce-layout']);
	unset($arr['woocommerce-smallscreen']);
	unset($arr['woocommerce-general']);
	return $arr;
}

/**
 * Loop Products 
 * Remove Shop Title
 *
*/
add_filter('woocommerce_show_page_title', function(){ return false;});

// Gallery Thumbnail Size 
add_filter( 'woocommerce_get_image_size_gallery_thumbnail', function( $size ) {
	//$smof_data = of_get_options();
	$size['width'] = 180;
    $size['height'] = 200;
    $size['crop'] = 1;
    return $size;
} );

function organicfood_woo_container_class(){
	$smof_data = of_get_options();
	echo 'container';
}
function organicfood_woo_row_class(){
	$smof_data = of_get_options();
	$clss = [];
	if(!empty($smof_data['loop_left_right_sidebar'])){
		switch ($smof_data['loop_left_right_sidebar']) {
			case 'left':
				$clss[] = 'sidebar-left';
				break;
			case 'right':
				$clss[] = 'sidebar-right';
				break;
		}
	}else{
		$clss[] = 'sidebar-right';
	}
	echo implode(' ', $clss);
}
function organicfood_woo_content_css_class(){
	$smof_data = of_get_options();
	$clss = ['woo-content-area'];   
	if(!empty($smof_data['loop_left_right_sidebar']) && ($smof_data['loop_left_right_sidebar'] == 'left') || $smof_data['loop_left_right_sidebar'] == 'right'){  
		if(is_active_sidebar( 'cshero-woo-sidebar' )){
	        $clss[] = 'col-sx-12 col-sm-12 col-md-9 col-lg-9';
	    }else{
	    	$clss[] = 'col-sx-12 col-sm-12 col-md-12 col-lg-12';
	    }
	}else{
		if(isset($smof_data['layout']))
			$clss[] = 'col-sx-12 col-sm-12 col-md-9 col-lg-9';
		else
			$clss[] = 'col-sx-12 col-sm-12 col-md-12 col-lg-12';
	}
    
	echo implode(' ', $clss);
	 
}
function organicfood_loop_start_class(){
	$smof_data = of_get_options();
	$clss = ['products'];   
	if(!empty($smof_data['shop_loop_col_xl']))  
		$clss[] = 'columns-'. absint($smof_data['shop_loop_col_xl']);
	else
		$clss[] = 'columns-4';
	if(!empty($smof_data['shop_loop_col_lg']))  
		$clss[] = 'columns-lg-'. absint($smof_data['shop_loop_col_lg']);
	else
		$clss[] = 'columns-lg-3';
	if(!empty($smof_data['shop_loop_col_md']))  
		$clss[] = 'columns-md-'. absint($smof_data['shop_loop_col_md']);
	else
		$clss[] = 'columns-md-3';
	if(!empty($smof_data['shop_loop_col_sm']))  
		$clss[] = 'columns-sm-'. absint($smof_data['shop_loop_col_sm']);
	else
		$clss[] = 'columns-sm-2';
	if(!empty($smof_data['shop_loop_col_xs'])) 
		$clss[] = 'columns-xs-'. absint($smof_data['shop_loop_col_xs']); 
	else
		$clss[] = 'columns-xs-1'; 

	return implode(' ', $clss);
}
function organicfood_woo_sidebar(){
 
	if(is_active_sidebar( 'cshero-woo-sidebar' )){
        $cl_sidebar = 'woo-sidebar col-sx-12 col-sm-12 col-md-3 col-lg-3';
        echo '<div class="'. esc_attr($cl_sidebar) .'">';
            do_action('woocommerce_sidebar');
        echo '</div>';
    }
     
}
  
add_filter( 'woocommerce_product_loop_start', 'organicfood_product_loop_start' );
function organicfood_product_loop_start($html){
	$html = '<ul class="'.organicfood_loop_start_class().'">';
	return $html;
}

add_action('woocommerce_before_shop_loop','organicfood_before_shop_loop_open', 11);
function organicfood_before_shop_loop_open(){
	echo '<div class="shop-loop-result-count-order">';
}

add_action('woocommerce_before_shop_loop','organicfood_before_shop_loop_close', 40);
function organicfood_before_shop_loop_close(){
	echo '</div>';
}

remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );

add_action( 'woocommerce_before_shop_loop_item_title','organicfood_before_shop_loop_item_title_open', 1);
function organicfood_before_shop_loop_item_title_open(){
	echo '<div class="loop-product-image" onclick="">';
}

add_action( 'woocommerce_before_shop_loop_item_title','organicfood_before_shop_loop_item_title_add_to_cart', 12);
function organicfood_before_shop_loop_item_title_add_to_cart(){
	woocommerce_template_loop_add_to_cart();
}

add_action( 'woocommerce_before_shop_loop_item_title','organicfood_before_shop_loop_item_title_close', 12);
function organicfood_before_shop_loop_item_title_close(){
	echo '</div>';
}


add_action( 'woocommerce_shop_loop_item_title', 'organicfood_shop_loop_item_title_open', 1);
function organicfood_shop_loop_item_title_open(){
	echo '<div class="loop-product-content">';
}

remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );

add_action( 'woocommerce_shop_loop_item_title', 'organicfood_template_loop_product_title', 10);
function organicfood_template_loop_product_title() {
	echo '<div class="loop-product-title"><a href="'.get_the_permalink().'">' . get_the_title() . '</a></div>';
}
/*remove_action( 'woocommerce_after_shop_loop_item_title','woocommerce_template_loop_rating', 5);
add_action( 'woocommerce_after_shop_loop_item_title','organicfood_template_loop_rating', 5);

function organicfood_template_loop_rating(){
	echo 'aaaaaaaa';
}*/

add_action( 'woocommerce_after_shop_loop_item', 'organicfood_shop_loop_item_title_close', 1);
function organicfood_shop_loop_item_title_close(){
	echo '</div>';
}