<?php

add_action('init', 'page_title_integrateWithVC');

function page_title_integrateWithVC() {
    vc_map(array(
        "name" => esc_html__("Page Title", 'organicfood'),
        "base" => "page-title",
        "class" => "page-title",
        "category" => esc_html__('Organic Food', 'organicfood'),
        "icon" => "of-icon-for-vc",
        "params" => array(
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Type", 'organicfood'),
                "param_name" => "type",
                "value" => array(
                    "Default" => "default",
                    "Custom" => "custom",
                ),
				"std" => "default",
                "description" => esc_html__('Select type of page title.', 'organicfood')
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__("Custom Title", 'organicfood'),
                "param_name" => "custom_title",
                "value" => "",
                "dependency" => array(
                    "element"=>"type",
                    "value"=>"custom"
                ),
                "description" => esc_html__("Please, Enter custom text of page title.", 'organicfood')
            ),
            array(
                "type" => "colorpicker",
                "class" => "",
                "heading" => esc_html__("Color", 'organicfood'),
                "param_name" => "color",
                "value" => "",
                "description" => esc_html__("Select color of page title.", 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Padding", 'organicfood'),
                "param_name" => "padding",
                "value" => "",
                "description" => esc_html__('Please, Enter padding of page title. Default: 0', 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Margin", 'organicfood'),
                "param_name" => "margin",
                "value" => "",
                "description" => esc_html__('Please, Enter margin of page title. Default: 0', 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Extra Class", 'organicfood'),
                "param_name" => "el_class",
                "value" => "",
                "description" => esc_html__("Extra Class.", 'organicfood')
            ),
        )
    ));
}
