<?php

add_action('init', 'panel_box_integrateWithVC');

function panel_box_integrateWithVC() {
    vc_map(array(
        "name" => esc_html__("Panel Box", 'organicfood'),
        "base" => "panel-box",
        "class" => "panel-box",
        "category" => esc_html__('Organic Food', 'organicfood'),
        "icon" => "of-icon-for-vc",
        "params" => array(
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__("Title", 'organicfood'),
                "param_name" => "title",
                "value" => "",
                "description" => esc_html__("Title.", 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Icon", 'organicfood'),
                "param_name" => "icon",
                "value" => "fa fa-plus-circle",
                "description" => esc_html__("Icon.", 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Tooltip Title", 'organicfood'),
                "param_name" => "tooltip_title",
                "value" => "",
                "description" => esc_html__("Tooltip Title.", 'organicfood')
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Tooltip Position", 'organicfood'),
                "param_name" => "tooltip_pos",
                "value" => array(
                    "Top" => 'top',
                    "Right" => 'right',
                    "Bottom" => 'bottom',
                    "Left" => 'left'
                ),
				"std" => "top",
                "description" => esc_html__("Tooltip Position.", 'organicfood'),
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Animation", 'organicfood'),
                "param_name" => "animation",
                "value" => array(
                    "No" => "",
                    "Top to bottom" => "top-to-bottom",
                    "Bottom to top" => "bottom-to-top",
                    "Left to right" => "left-to-right",
                    "Right to left" => "right-to-left",
                    "Appear from center" => "appear"
                ),
				"std" => "",
                "description" => esc_html__("Animation", 'organicfood')
            ),
            array(
                "type" => "textfield",
                "class" => "",
                "heading" => esc_html__("Extra Class", 'organicfood'),
                "param_name" => "el_class",
                "value" => "",
                "description" => esc_html__("Extra Class.", 'organicfood')
            ),
        )
    ));
}
