<?php

function ww_add_post_type_produce() {
    // Register taxonomy
    $labels = array(
            'name'              => esc_html__( 'Produce Category', 'organicfood' ),
            'singular_name'     => esc_html__( 'Produce Category', 'organicfood' ),
            'search_items'      => esc_html__( 'Search Produce Category', 'organicfood' ),
            'all_items'         => esc_html__( 'All Produce Category', 'organicfood' ),
            'parent_item'       => esc_html__( 'Parent Produce Category', 'organicfood' ),
            'parent_item_colon' => esc_html__( 'Parent Produce Category:', 'organicfood' ),
            'edit_item'         => esc_html__( 'Edit Produce Category', 'organicfood' ),
            'update_item'       => esc_html__( 'Update Produce Category', 'organicfood' ),
            'add_new_item'      => esc_html__( 'Add New Produce Category', 'organicfood' ),
            'new_item_name'     => esc_html__( 'New Produce Category Name', 'organicfood' ),
            'menu_name'         => esc_html__( 'Produce Category', 'organicfood' ),
    );

    $args = array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array( 'slug' => 'produce_category' ),
    );
    if(function_exists('custom_reg_taxonomy')) {
        custom_reg_taxonomy( 'produce_category', array( 'produce' ), $args );
    }
    //Register post type
    $labels = array(
        'name'               => _x('Produce', 'Post type general name', 'organicfood'),
        'singular_name'      => _x('Produce', 'Post type singular name', 'organicfood'),
        'add_new'            => _x('Add New', 'Produce Item', 'organicfood'),
        'add_new_item'       => esc_html__('Add New Item', 'organicfood'),
        'edit_item'          => esc_html__('Edit Item', 'organicfood'),
        'new_item'           => esc_html__('New Item', 'organicfood'),
        'all_items'          => esc_html__('All Items', 'organicfood'),
        'view_item'          => esc_html__('View Item', 'organicfood'),
        'search_items'       => esc_html__('Search Items', 'organicfood'),
        'not_found'          => esc_html__('No produces found.', 'organicfood'),
        'not_found_in_trash' => esc_html__('No produces found.', 'organicfood'),
        'parent_item_colon'  => '',
        'menu_name'          => esc_html__('Produce', 'organicfood')
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'query_var' => true,
        'rewrite' => true,
        'capability_type' => 'post',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => 5,
        'menu_icon' => 'dashicons-cart',
        'supports' => array('title', 'editor', 'thumbnail', 'comments')
    );
    
    if(function_exists('custom_reg_post_type')) {
        custom_reg_post_type( 'produce', $args );
    }
    
}
add_action('init', 'ww_add_post_type_produce');