<?php

add_filter('ef3-theme-options-opt-name', 'wp_organicfood_set_demo_opt_name');

function wp_organicfood_set_demo_opt_name(){
    return 'opt_theme_options';
}

add_filter('ef3-replace-content', 'wp_organicfood_replace_content', 10 , 2);

function wp_organicfood_replace_content($replaces, $attachment){
    return array(
        '/tax_query:/' => 'remove_query:',
        '/categories:/' => 'remove_query:',
    );
}

add_filter('ef3-replace-theme-options', 'wp_organicfood_replace_theme_options');

function wp_organicfood_replace_theme_options(){
    return array(
        'dev_mode' => 0,
    );
}
add_filter('ef3-enable-create-demo', 'wp_organicfood_enable_create_demo');

function wp_organicfood_enable_create_demo(){
    return false;
}

function wp_organicfood_update_theme_option(){
    $option_json = get_template_directory_uri() . '/inc/demo-data/organicfood/option.txt';
    $option_json = wp_remote_get( $option_json );
    $option_data = $option_json['body'];
    of_save_options(unserialize(base64_decode($option_data))); 
}

add_action('ef3-import-finish', 'wp_organicfood_update_theme_option');

function wp_organicfood_import_grid(){
    if(file_exists(ABSPATH .'wp-content/plugins/essential-grid/admin/includes/import.class.php')){
        require_once(ABSPATH .'wp-content/plugins/essential-grid/admin/includes/import.class.php');
         
        $folder_dir = trailingslashit(get_template_directory().'/inc/demo-data/organicfood/grid');

        if(!file_exists($folder_dir . '/ess_grid.json')) exit();

        $im = new Essential_Grid_Import();
        $grid_extract = json_decode(file_get_contents($folder_dir . '/ess_grid.json'), true); 
        $grids = @$grid_extract['grids'];
        if(!empty($grids) && is_array($grids)){
            $grids_imported = $im->import_grids($grids);
        }
    } 
}

add_action('ef3-import-finish', 'wp_organicfood_import_grid');

function wp_organicfood_set_home_page(){

    $home_page = 'Organic Home';

    $page = get_page_by_title($home_page);

    if(!isset($page->ID))
        return ;
         
        update_option('show_on_front', 'page');
        update_option('page_on_front', $page->ID);
}

add_action('ef3-import-finish', 'wp_organicfood_set_home_page');


function wp_organicfood_set_menu_location(){

    $setting = array(
            'Main Menu' => 'main_navigation'
    );

    $navs = wp_get_nav_menus();

    $new_setting = array();

    foreach ($navs as $nav){

        if(!isset($setting[$nav->name]))
            continue;

            $id = $nav->term_id;
            $location = $setting[$nav->name];

            $new_setting[$location] = $id;
    }

    set_theme_mod('nav_menu_locations', $new_setting);
}
 
add_action('ef3-import-finish', 'wp_organicfood_set_menu_location');

function wp_organicfood_set_woo_page(){
    
    $woo_pages = array(
        'woocommerce_shop_page_id' => 'Shop',
        'woocommerce_cart_page_id' => 'Cart',
        'woocommerce_checkout_page_id' => 'Checkout'
    );
    
    foreach ($woo_pages as $key => $woo_page){
    
        $page = get_page_by_title($woo_page);
    
        if(!isset($page->ID))
            return ;
             
        update_option($key, $page->ID);
    
    }
}

add_action('ef3-import-finish', 'wp_organicfood_set_woo_page');

add_action('ef3-import-start', 'wp_eagleeyes_move_trash', 1);
if(!function_exists('wp_eagleeyes_move_trash')){
    function wp_eagleeyes_move_trash(){
        wp_trash_post(1);
        wp_trash_post(2);
    }
}
/**
 * Crop image
 */
add_action('ef3-import-finish', 'wp_organicfood_crop_images',99);
function wp_organicfood_crop_images() {
    $query = array(
        'post_type'      => 'attachment',
        'posts_per_page' => -1,
        'post_status'    => 'inherit',
    );
    $media = new WP_Query($query);
    if ($media->have_posts()) {
        foreach ($media->posts as $image) {
            if (strpos($image->post_mime_type, 'image/') !== false) {
                $image_path = get_attached_file($image->ID);
                $metadata = wp_generate_attachment_metadata($image->ID, $image_path);
                wp_update_attachment_metadata($image->ID, $metadata);
            }
        }
    }
}